/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileHelper {
    public static InputStream createInputStream(Class<?> caller, String name) throws IOException {
        InputStream is;
        if (caller == null) {
            caller = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        }
        if ((is = caller.getResourceAsStream(name)) == null && (is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name)) == null) {
            Module module = caller.getClassLoader().getUnnamedModule();
            if (module != null) {
                is = module.getResourceAsStream(name);
            }
            if (is == null) {
                throw new FileNotFoundException("no such resource: " + name);
            }
        }
        is = new BufferedInputStream(is);
        return is;
    }

    public static Properties loadProperties(String name, boolean asResource) throws IOException {
        Properties dbProps = new Properties();
        if (name != null) {
            if (((String)name).indexOf(46) < 0) {
                name = (String)name + ".properties";
            }
            if (!((String)name).startsWith("/")) {
                name = "/" + (String)name;
            }
            try (InputStream is = asResource ? FileHelper.createInputStream(FileHelper.class, (String)name) : new FileInputStream((String)name);){
                dbProps.load(is);
            }
        }
        return dbProps;
    }

    public static Properties loadProperties(String name) throws IOException {
        try {
            return FileHelper.loadProperties(name, false);
        }
        catch (FileNotFoundException e1) {
            return FileHelper.loadProperties(name, true);
        }
    }

    public static void copy(File source, File dest) throws IOException {
        try (FileChannel sourceChannel = new FileInputStream(source).getChannel();
             FileChannel destChannel = new FileOutputStream(dest).getChannel();){
            destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
    }

    public static byte[] download(URL url) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                outputStream.write(dataBuffer, 0, bytesRead);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    public static void removeDirectory(String name) throws IOException {
        Path path = Paths.get(name, new String[0]);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void unzip(File zipFile, File destDir, Consumer<File> fileConsumer) throws IOException {
        byte[] buffer = new byte[1024];
        HashSet<File> createdDirs = new HashSet<File>();
        try (ZipInputStream zipStream = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry zipEntry;
            while ((zipEntry = zipStream.getNextEntry()) != null) {
                File destFile = new File(destDir, zipEntry.getName());
                if (fileConsumer != null) {
                    fileConsumer.accept(destFile);
                }
                if (destFile.getCanonicalPath().startsWith(destDir.getCanonicalPath())) {
                    if (zipEntry.isDirectory()) continue;
                    File dir = destFile.getParentFile();
                    if (!createdDirs.contains(dir)) {
                        dir.mkdirs();
                        createdDirs.add(dir);
                    }
                    FileOutputStream outputStream = new FileOutputStream(destFile);
                    try {
                        int len;
                        while ((len = zipStream.read(buffer)) > 0) {
                            outputStream.write(buffer, 0, len);
                        }
                        continue;
                    }
                    finally {
                        outputStream.close();
                        continue;
                    }
                }
                throw new IOException("zip slip detected for " + zipEntry.getName());
            }
        }
    }

    private FileHelper() {
    }
}

