/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import org.tentackle.common.DateHelper;
import org.tentackle.common.Freezable;
import org.tentackle.common.TentackleRuntimeException;

public class Time
extends java.sql.Time
implements Freezable {
    private static final long serialVersionUID = 1L;
    private boolean frozen;

    public static Time createFrozen(long epoch) {
        Time time = new Time(epoch);
        time.freeze();
        return time;
    }

    public Time(long time) {
        super(time);
    }

    public Time() {
        this(System.currentTimeMillis());
    }

    @Override
    public Time clone() {
        Time time = (Time)super.clone();
        time.frozen = false;
        return time;
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    @Override
    public void setTime(long time) {
        this.assertNotFrozen();
        super.setTime(time);
    }

    @Override
    @Deprecated
    public void setYear(int year) {
        this.assertNotFrozen();
        super.setYear(year);
    }

    @Override
    @Deprecated
    public void setMonth(int month) {
        this.assertNotFrozen();
        super.setMonth(month);
    }

    @Override
    @Deprecated
    public void setDate(int date) {
        this.assertNotFrozen();
        super.setDate(date);
    }

    @Override
    @Deprecated
    public void setHours(int hours) {
        this.assertNotFrozen();
        super.setHours(hours);
    }

    @Override
    @Deprecated
    public void setMinutes(int minutes) {
        this.assertNotFrozen();
        super.setMinutes(minutes);
    }

    @Override
    @Deprecated
    public void setSeconds(int seconds) {
        this.assertNotFrozen();
        super.setSeconds(seconds);
    }

    private void assertNotFrozen() {
        if (this.frozen) {
            throw new TentackleRuntimeException("time is frozen");
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Calendar calendar = DateHelper.today();
        calendar.setTime(this);
        s.writeByte(calendar.get(11));
        s.writeByte(calendar.get(12));
        s.writeByte(calendar.get(13));
        s.writeShort(calendar.get(14));
        s.writeBoolean(this.frozen);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        byte hours = s.readByte();
        byte minutes = s.readByte();
        byte seconds = s.readByte();
        short millis = s.readShort();
        Calendar cal = DateHelper.today();
        cal.set(1970, 0, 1, hours, minutes, seconds);
        cal.set(14, millis);
        super.setTime(cal.getTimeInMillis());
        this.frozen = s.readBoolean();
    }
}

