/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.util.Calendar;
import org.tentackle.common.Date;
import org.tentackle.common.LocaleProvider;
import org.tentackle.common.Time;
import org.tentackle.common.Timestamp;

public final class DateHelper {
    public static final Date MIN_DATE = new Date(0L);
    public static final Timestamp MIN_TIMESTAMP = new Timestamp(0L);

    public static long toMillis(java.util.Date date) {
        return date == null ? 0L : date.getTime();
    }

    public static Date toDate(java.util.Date date) {
        return date == null ? null : new Date(date.getTime());
    }

    public static Date toDate(Calendar cal) {
        return cal == null ? null : new Date(cal.getTimeInMillis());
    }

    public static Time toTime(java.util.Date date) {
        return date == null ? null : new Time(date.getTime());
    }

    public static Time toTime(Calendar cal) {
        return cal == null ? null : new Time(cal.getTimeInMillis());
    }

    public static Timestamp toTimestamp(java.util.Date date) {
        return date == null ? null : new Timestamp(date.getTime());
    }

    public static Timestamp toTimestamp(Calendar cal) {
        return cal == null ? null : new Timestamp(cal.getTimeInMillis());
    }

    public static Calendar today() {
        return Calendar.getInstance(LocaleProvider.getInstance().getLocale());
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = DateHelper.today();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar toCalendar(Timestamp timestamp) {
        Calendar calendar = DateHelper.today();
        calendar.setTime(timestamp);
        return calendar;
    }

    public static Calendar toCalendar(Time time) {
        Calendar calendar = DateHelper.today();
        calendar.setTime(time);
        return calendar;
    }

    public static Date today(int dayOffset, int monthOffset, int yearOffset) {
        Calendar cal = DateHelper.today();
        cal.add(5, dayOffset);
        cal.add(2, monthOffset);
        cal.add(1, yearOffset);
        return new Date(cal.getTimeInMillis());
    }

    public static Time daytime() {
        return new Time(System.currentTimeMillis());
    }

    public static Time daytime(int secondOffset, int minuteOffset, int hourOffset) {
        Calendar cal = DateHelper.today();
        cal.add(13, secondOffset);
        cal.add(12, minuteOffset);
        cal.add(10, hourOffset);
        return new Time(cal.getTimeInMillis());
    }

    public static Timestamp now(long offsetMillis) {
        return new Timestamp(System.currentTimeMillis() + offsetMillis);
    }

    public static Timestamp now() {
        return DateHelper.now(0L);
    }

    public static void setMidnight(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static int getCurrentYear() {
        return DateHelper.today().get(1);
    }

    public static int getCurrentMonth() {
        return DateHelper.today().get(2);
    }

    public static int getCurrentDay() {
        return DateHelper.today().get(5);
    }

    public static int derive4DigitYearFrom2DigitYear(int year, int currentYear, int yearWindow) {
        int current2Year = currentYear % 100;
        int currentCentury = currentYear - current2Year;
        year %= 100;
        if (yearWindow >= 0 && yearWindow < 100) {
            int diff = year - current2Year;
            if (diff > 0) {
                if (diff > yearWindow) {
                    return currentCentury - 100 + year;
                }
            } else if (diff < 0 && diff < yearWindow - 100) {
                return currentCentury + 100 + year;
            }
        }
        return currentCentury + year;
    }

    public static int derive4DigitYearFrom2DigitYear(int year) {
        return DateHelper.derive4DigitYearFrom2DigitYear(year, DateHelper.today().get(1), 50);
    }

    public static int deriveYearFromMonth(int month, int currentMonth, int currentYear, int monthWindow) {
        if (monthWindow >= 0 && monthWindow < 12) {
            int diff = (month %= 12) - currentMonth;
            if (diff > 0) {
                if (diff > monthWindow) {
                    return currentYear - 1;
                }
            } else if (diff < 0 && diff < monthWindow - 12) {
                return currentYear + 1;
            }
        }
        return currentYear;
    }

    public static int deriveYearFromMonth(int month) {
        Calendar calendar = DateHelper.today();
        return DateHelper.deriveYearFromMonth(month, calendar.get(2), calendar.get(1), 6);
    }

    public static int deriveMonthFromDay(int day, int currentDay, int currentMonth, int dayWindow) {
        if (dayWindow >= 0 && dayWindow < 31) {
            int diff = (day %= 31) - currentDay;
            if (diff > 0) {
                if (diff > dayWindow) {
                    return currentMonth - 1;
                }
            } else if (diff < 0 && diff < dayWindow - 31) {
                return currentMonth + 1;
            }
        }
        return currentMonth;
    }

    public static int deriveMonthFromDay(int day) {
        Calendar calendar = DateHelper.today();
        return DateHelper.deriveMonthFromDay(day, calendar.get(5), calendar.get(2), 15);
    }

    private DateHelper() {
    }
}

