/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.tentackle.common.LocaleProvider;
import org.tentackle.common.ParameterString;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;

public class I18NText
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_PAR = "default";
    private final LinkedHashMap<Locale, String> textMap;
    private final Locale defaultLocale;

    public static I18NText valueOf(String text) {
        return new I18NText(text);
    }

    public I18NText() {
        this.textMap = new LinkedHashMap();
        this.defaultLocale = null;
    }

    public I18NText(String text) {
        this(LocaleProvider.getInstance().getLocale(), text);
    }

    public I18NText(Locale locale, String text) {
        this.textMap = new LinkedHashMap();
        this.defaultLocale = this.apply(locale, text, this.textMap, null);
    }

    public I18NText(ParameterString parameterString) {
        LocaleProvider localeProvider = LocaleProvider.getInstance();
        String parameter = parameterString.getParameter(DEFAULT_PAR);
        this.defaultLocale = parameter == null ? null : localeProvider.fromTag(parameter);
        this.textMap = new LinkedHashMap();
        for (String tag : parameterString.getParameterNames()) {
            Locale locale = localeProvider.fromTag(tag);
            if (locale == null || !localeProvider.isLocaleSupported(locale) || (parameter = parameterString.getParameter(tag)) == null) continue;
            this.textMap.put(localeProvider.getEffectiveLocale(locale), parameter);
        }
    }

    protected I18NText(LinkedHashMap<Locale, String> textMap, Locale defaultLocale) {
        this.textMap = textMap;
        this.defaultLocale = defaultLocale;
    }

    protected Locale apply(Locale locale, String text, LinkedHashMap<Locale, String> withTextMap, Locale withDefaultLocale) {
        LocaleProvider localeProvider = LocaleProvider.getInstance();
        if (!localeProvider.isLocaleSupported(locale)) {
            throw new TentackleRuntimeException("unsupported locale: " + locale);
        }
        locale = this.narrowLocale(localeProvider.getEffectiveLocale(locale));
        if (StringHelper.isAllWhitespace(text)) {
            withTextMap.remove(locale);
            if (locale.equals(withDefaultLocale)) {
                withDefaultLocale = null;
                if (!withTextMap.isEmpty()) {
                    withDefaultLocale = localeProvider.getEffectiveLocale(withTextMap.keySet().iterator().next());
                }
            }
        } else {
            if (withDefaultLocale == null) {
                if (withTextMap.isEmpty() && !locale.equals(localeProvider.getFallbackLocale())) {
                    withDefaultLocale = localeProvider.getEffectiveLocale(locale);
                }
            } else if (locale.equals(localeProvider.getFallbackLocale())) {
                withDefaultLocale = null;
            }
            withTextMap.put(locale, text);
        }
        return withDefaultLocale;
    }

    public I18NText with(Locale locale, String text) {
        LinkedHashMap withTextMap = (LinkedHashMap)this.textMap.clone();
        Locale withDefaultLocale = this.apply(locale, text, withTextMap, this.defaultLocale);
        return new I18NText(withTextMap, withDefaultLocale);
    }

    public I18NText with(String text) {
        return this.with(LocaleProvider.getInstance().getLocale(), text);
    }

    public String get(Locale locale) {
        LocaleProvider localeProvider = LocaleProvider.getInstance();
        String text = this.textMap.get(this.narrowLocale(localeProvider.getEffectiveLocale(locale)));
        if (text == null) {
            text = this.defaultLocale != null ? this.textMap.get(this.defaultLocale) : this.textMap.get(localeProvider.getFallbackLocale());
        }
        return text;
    }

    public String get() {
        return this.get(LocaleProvider.getInstance().getLocale());
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public Map<Locale, String> getTranslations() {
        return Map.copyOf(this.textMap);
    }

    public boolean isEmpty() {
        return this.textMap.isEmpty();
    }

    public ParameterString toParameterString() {
        ParameterString ps = new ParameterString();
        LocaleProvider localeProvider = LocaleProvider.getInstance();
        if (this.defaultLocale != null) {
            ps.setParameter(DEFAULT_PAR, localeProvider.toTag(this.defaultLocale));
        }
        for (Map.Entry<Locale, String> entry : this.textMap.entrySet()) {
            ps.setParameter(localeProvider.toTag(entry.getKey()), entry.getValue());
        }
        return ps;
    }

    public String toString() {
        return this.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        I18NText i18NText = (I18NText)o;
        if (!this.textMap.equals(i18NText.textMap)) {
            return false;
        }
        return Objects.equals(this.defaultLocale, i18NText.defaultLocale);
    }

    public int hashCode() {
        int result = this.textMap.hashCode();
        result = 31 * result + (this.defaultLocale != null ? this.defaultLocale.hashCode() : 0);
        return result;
    }

    protected Locale narrowLocale(Locale locale) {
        if (!locale.getVariant().isEmpty() || !locale.getCountry().isEmpty()) {
            locale = new Locale(locale.getLanguage());
        }
        return locale;
    }
}

