/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.File;
import java.util.StringTokenizer;

public class ToolFinder {
    private static final String[] WINDOWS_SUFFIXES = new String[]{".exe", ".cmd", ".bat"};
    private static final String[] UNIX_SUFFIXES = new String[]{".sh"};

    public File find(String toolName) {
        File file = new File(toolName);
        if (!(file.canExecute() || toolName.contains("/") || File.separatorChar != '/' && toolName.contains(File.separator))) {
            file = null;
            String path = System.getenv("PATH");
            if (path != null) {
                StringTokenizer stok = new StringTokenizer(path, File.pathSeparator);
                while (file == null && stok.hasMoreTokens()) {
                    File toolDir = new File(stok.nextToken().trim());
                    file = this.loadTool(toolDir, toolName);
                }
            }
        }
        return file;
    }

    protected File loadTool(File toolDir, String toolName) {
        File file = new File(toolDir, toolName);
        if (!file.canExecute()) {
            String suffix;
            file = null;
            String[] stringArray = File.pathSeparatorChar == ':' ? UNIX_SUFFIXES : WINDOWS_SUFFIXES;
            int n = stringArray.length;
            for (int i = 0; i < n && !(file = new File(toolDir, toolName + (suffix = stringArray[i]))).canExecute(); ++i) {
                file = null;
            }
        }
        return file;
    }
}

