/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.spi.ResourceBundleControlProvider;
import org.tentackle.common.BundleFactory;
import org.tentackle.common.BundleSupport;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.TentackleRuntimeException;

@Service(value=BundleFactory.class)
public class DefaultBundleFactory
implements BundleFactory {
    private final List<ResourceBundleControlProvider> providers = this.createProviders();
    private final Map<String, ResourceBundle.Control> controlMap = new ConcurrentHashMap<String, ResourceBundle.Control>();
    private final Map<String, BundleSupport> moduleBundlesMap = new HashMap<String, BundleSupport>();
    private ClassLoader classLoader;

    public DefaultBundleFactory() {
        for (BundleSupport support : BundleSupport.getBundles(this.getClass().getClassLoader())) {
            if (support.getModuleInfo() == null) continue;
            this.moduleBundlesMap.put(support.getBundleName(), support);
            this.moduleBundlesMap.put(support.getClassName(), support);
        }
    }

    @Override
    public void clearCache() {
        ResourceBundle.clearCache(this.getClass().getClassLoader());
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public final List<ResourceBundleControlProvider> getProviders() {
        return this.providers;
    }

    @Override
    public ResourceBundle.Control getControl(String baseName) {
        if (this.providers != null) {
            ResourceBundle.Control control = this.controlMap.get(baseName);
            if (control != null) {
                return control;
            }
            for (ResourceBundleControlProvider provider : this.providers) {
                control = provider.getControl(baseName);
                if (control == null) continue;
                this.controlMap.put(baseName, control);
                return control;
            }
        }
        return null;
    }

    @Override
    public ResourceBundle findBundle(String baseName, Locale locale) {
        BundleSupport support = this.moduleBundlesMap.get(baseName = this.normalizeBasename(baseName));
        if (support != null) {
            return this.getBundle(support, locale);
        }
        ResourceBundle.Control control = this.getControl(baseName);
        if (this.classLoader == null) {
            return control == null ? ResourceBundle.getBundle(baseName, locale) : ResourceBundle.getBundle(baseName, locale, control);
        }
        return control == null ? ResourceBundle.getBundle(baseName, locale, this.classLoader) : ResourceBundle.getBundle(baseName, locale, this.classLoader, control);
    }

    @Override
    public ResourceBundle findBundle(String baseName, Locale locale, ClassLoader loader) {
        BundleSupport support = this.moduleBundlesMap.get(baseName = this.normalizeBasename(baseName));
        if (support != null) {
            return this.getBundle(support, locale);
        }
        ResourceBundle.Control control = this.getControl(baseName);
        return control == null ? ResourceBundle.getBundle(baseName, locale, loader) : ResourceBundle.getBundle(baseName, locale, loader, control);
    }

    protected ResourceBundle getBundle(BundleSupport support, Locale locale) {
        return support.getModuleInfo().getHook().getBundle(support.getBundleName(), locale);
    }

    protected List<ResourceBundleControlProvider> createProviders() {
        ArrayList<ResourceBundleControlProvider> providerList = null;
        try {
            for (Class<ResourceBundleControlProvider> clazz : ServiceFactory.getServiceFinder().findServiceProviders(ResourceBundleControlProvider.class)) {
                if (providerList == null) {
                    providerList = new ArrayList<ResourceBundleControlProvider>();
                }
                providerList.add(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new TentackleRuntimeException("cannot load bundle control providers", ex);
        }
        return providerList;
    }

    protected String normalizeBasename(String baseName) {
        while (baseName.startsWith("/")) {
            baseName = baseName.substring(1);
        }
        return baseName;
    }
}

