/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.util.Objects;
import java.util.Properties;
import org.tentackle.common.Cryptor;

public class EncryptedProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    public EncryptedProperties() {
    }

    public EncryptedProperties(int initialCapacity) {
        super(initialCapacity);
    }

    public EncryptedProperties(Properties defaults) {
        super(defaults);
    }

    @Override
    public EncryptedProperties clone() {
        return (EncryptedProperties)super.clone();
    }

    @Override
    public String getProperty(String key) {
        return this.getValue(key).getText();
    }

    public String getPropertyBlunt(String key) {
        return super.getProperty(key);
    }

    public char[] getPropertyAsChars(String key) {
        return this.getValue(key).getChars();
    }

    public char[] getPropertyAsChars(String key, char[] defaults) {
        char[] chars = this.getPropertyAsChars(key);
        return chars == null ? defaults : chars;
    }

    public void setEncryptedProperty(String key, String value) {
        Cryptor cryptor = Cryptor.getInstance();
        if (cryptor != null) {
            this.setProperty(key, "~" + cryptor.encrypt64(Objects.requireNonNull(value, "missing value (String)")));
        } else {
            this.setProperty(key, value);
        }
    }

    public void setEncryptedProperty(String key, char[] value) {
        value = Objects.requireNonNull(value, "missing value (char[])");
        Cryptor cryptor = Cryptor.getInstance();
        if (cryptor != null) {
            this.setProperty(key, "~" + Cryptor.getInstance().encrypt64(value));
        } else {
            super.setProperty(key, String.valueOf(value));
        }
    }

    private Value getValue(String key) {
        String text = super.getProperty(key);
        boolean encrypted = false;
        if (text != null) {
            if (text.startsWith("~")) {
                text = text.substring(1);
                encrypted = true;
            } else if (text.startsWith("\\~")) {
                text = text.substring(1);
            }
        }
        return new Value(text, encrypted);
    }

    private record Value(String text, boolean encrypted) {
        private String getText() {
            return this.encrypted ? Cryptor.getInstanceSafely().decrypt64(this.text) : this.text;
        }

        private char[] getChars() {
            return this.encrypted ? Cryptor.getInstanceSafely().decrypt64ToChars(this.text) : (char[])(this.text == null ? null : this.text.toCharArray());
        }
    }
}

