/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.tentackle.common.CommonCommonBundle;
import org.tentackle.common.FileHelper;
import org.tentackle.common.StringNormalizer;
import org.tentackle.common.TentackleRuntimeException;

public final class StringHelper {
    private static int maxLogCollectionSize = 10;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String[] JAVA_RESERVED_WORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void setMaxLogCollectionSize(int maxLogCollectionSize) {
        StringHelper.maxLogCollectionSize = maxLogCollectionSize;
    }

    public static int getMaxLogCollectionSize() {
        return maxLogCollectionSize;
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        return a == b || a != null && a.equalsIgnoreCase(b);
    }

    public static String toUpper(String str) {
        if (str != null) {
            str = str.toUpperCase(Locale.ROOT);
        }
        return str;
    }

    public static String toLower(String str) {
        if (str != null) {
            str = str.toLowerCase(Locale.ROOT);
        }
        return str;
    }

    public static String firstToUpper(String str) {
        if (str != null && str.length() > 0) {
            StringBuilder buf = new StringBuilder(str);
            buf.deleteCharAt(0);
            buf.insert(0, Character.toUpperCase(str.charAt(0)));
            return buf.toString();
        }
        return null;
    }

    public static String firstToLower(String str) {
        if (str != null && str.length() > 0) {
            StringBuilder buf = new StringBuilder(str);
            buf.deleteCharAt(0);
            buf.insert(0, Character.toLowerCase(str.charAt(0)));
            return buf.toString();
        }
        return null;
    }

    public static String getPlainClassName(String className) {
        int ndx = className.indexOf(60);
        if (ndx > 0) {
            return className.substring(0, ndx).trim();
        }
        return className;
    }

    public static String getContinuedLine(String line) {
        int len;
        if (line != null && (len = line.length()) > 0 && line.charAt(len - 1) == '\\') {
            int ndx = len - 1;
            int slashCount = 1;
            while (--ndx >= 0 && line.charAt(ndx) == '\\') {
                ++slashCount;
            }
            if (slashCount & true) {
                return line.substring(0, len - 1);
            }
        }
        return null;
    }

    public static int indexAnyOf(String str, String anyOf) {
        int index = -1;
        if (anyOf != null && str != null) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (anyOf.indexOf(c) < 0) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static String toDoubleQuotes(String str) {
        StringBuilder buf = new StringBuilder();
        buf.append('\"');
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c == '\"' || c == '\\') {
                    buf.append('\\');
                } else if (Character.isISOControl(c)) {
                    c = ' ';
                }
                buf.append(c);
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    public static char charToEscaped(char c) {
        return switch (c) {
            case 'n' -> '\n';
            case 'r' -> '\r';
            case 't' -> '\t';
            case 'f' -> '\f';
            default -> c;
        };
    }

    public static String escapedToString(char c) {
        return switch (c) {
            case '\n' -> "\\n";
            case '\r' -> "\\r";
            case '\t' -> "\\t";
            case '\f' -> "\\f";
            default -> String.valueOf(c);
        };
    }

    public static String parseString(String str) {
        StringBuilder buf = new StringBuilder();
        if (str != null && str.length() > 0) {
            char quoteChar = str.charAt(0);
            if (quoteChar != '\"' && quoteChar != '\'') {
                quoteChar = '\u0000';
            }
            if (quoteChar != '\u0000') {
                char lastChar = str.charAt(str.length() - 1);
                if (lastChar != quoteChar || str.length() < 2) {
                    throw new TentackleRuntimeException("String <" + str + "> contains unbalanced quotes");
                }
                str = str.substring(1, str.length() - 1);
            }
            boolean escaped = false;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (escaped) {
                    buf.append(StringHelper.charToEscaped(c));
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                buf.append(c);
            }
        }
        return buf.toString();
    }

    public static String toParsableString(String str) {
        StringBuilder buf = new StringBuilder();
        boolean needQuotes = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'' || c == '\"' || c == '\\') {
                buf.append('\\').append(c);
                needQuotes = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                needQuotes = true;
                buf.append(StringHelper.escapedToString(c));
                continue;
            }
            buf.append(c);
        }
        if (needQuotes) {
            buf.insert(0, '\"');
            buf.append('\"');
        }
        return buf.toString();
    }

    public static List<String> split(String str, String delimiters) {
        ArrayList<String> parts = new ArrayList<String>();
        if (str != null) {
            StringBuilder part = null;
            boolean escaped = false;
            char quoteChar = '\u0000';
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (escaped) {
                    part.append(StringHelper.charToEscaped(c));
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    if (part != null) continue;
                    part = new StringBuilder();
                    continue;
                }
                if (c == '\'' || c == '\"') {
                    if (part == null) {
                        part = new StringBuilder();
                        part.append(c);
                        quoteChar = c;
                        continue;
                    }
                    if (quoteChar != '\u0000' && quoteChar != c) {
                        part.append(c);
                        continue;
                    }
                    part.append(c);
                    parts.add(part.toString());
                    part = null;
                    quoteChar = '\u0000';
                    continue;
                }
                if (delimiters.indexOf(c) >= 0) {
                    if (quoteChar == '\u0000') {
                        if (part == null) continue;
                        parts.add(part.toString());
                        part = null;
                        continue;
                    }
                    part.append(c);
                    continue;
                }
                if (part == null) {
                    part = new StringBuilder();
                }
                part.append(c);
            }
            if (part != null) {
                parts.add(part.toString());
            }
        }
        return parts;
    }

    public static boolean isFQCN(String className) {
        return className.contains(".") && StringHelper.isValidJavaClassName(className);
    }

    public static boolean isValidJavaClassName(String className) {
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex > 0) {
            String packageName = className.substring(0, dotIndex);
            className = className.substring(dotIndex + 1);
            if (!StringHelper.isValidJavaPackageName(packageName)) {
                return false;
            }
        }
        if (className.length() < 1) {
            return false;
        }
        char firstChar = className.charAt(0);
        if (!Character.isAlphabetic(firstChar) || !Character.isUpperCase(firstChar)) {
            return false;
        }
        for (int pos = 0; pos < className.length(); ++pos) {
            char c = className.charAt(pos);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaPackageName(String packageName) {
        boolean lastWasDot = true;
        for (int pos = 0; pos < packageName.length(); ++pos) {
            char c = packageName.charAt(pos);
            if (c == '.') {
                lastWasDot = true;
                continue;
            }
            if (lastWasDot) {
                lastWasDot = false;
                if (!Character.isDigit(c)) continue;
                return false;
            }
            if (Character.isDigit(c) || !Character.isUpperCase(c) && (Character.isAlphabetic(c) || c == '_')) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        char[] c = str.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    public static String readTextFromResource(Class<?> caller, String resourceName) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(FileHelper.createInputStream(caller, resourceName)));){
            String line;
            StringBuilder buf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            String string = buf.toString();
            return string;
        }
    }

    public static boolean isAllWhitespace(String str) {
        return str == null || str.isBlank();
    }

    public static boolean isReservedWord(String word) {
        if (word != null) {
            for (String rw : JAVA_RESERVED_WORDS) {
                if (!rw.equals(word)) continue;
                return true;
            }
        }
        return false;
    }

    public static String digitToString(Character digit) {
        return CommonCommonBundle.getString(String.valueOf(digit));
    }

    public static String stripEnclosingDoubleQuotes(String str) {
        if (str != null && !str.isEmpty()) {
            if (str.charAt(0) == '\"') {
                str = str.substring(1);
            }
            if (!str.isEmpty() && str.charAt(str.length() - 1) == '\"') {
                str = str.substring(0, str.length() - 1);
            }
        }
        return str;
    }

    public static String toFixedLength(String str, int length, char filler) {
        int len = 0;
        StringBuilder buf = new StringBuilder();
        if (str != null) {
            len = str.length();
            if (len > length) {
                buf.append(str, 0, length);
                len = length;
            } else {
                buf.append(str);
            }
        }
        while (len < length) {
            buf.append(filler);
            ++len;
        }
        return buf.toString();
    }

    public static String toFixedLength(String str, int length) {
        return StringHelper.toFixedLength(str, length, ' ');
    }

    public static String toFixedLengthLeftFill(String str, int length, char filler) {
        int len = 0;
        StringBuilder buf = new StringBuilder();
        if (str != null) {
            len = str.length();
            if (len > length) {
                buf.append(str, 0, length);
                len = length;
            } else {
                buf.append(str);
            }
        }
        while (len < length) {
            buf.insert(0, filler);
            ++len;
        }
        return buf.toString();
    }

    public static String toFixedLengthLeftFill(String str, int length) {
        return StringHelper.toFixedLengthLeftFill(str, length, ' ');
    }

    public static String toVarName(String str) {
        if (str != null) {
            int len = str.length();
            StringBuilder sbuf = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    sbuf.append(c);
                    continue;
                }
                if (c != '_' && !Character.isWhitespace(c)) continue;
                sbuf.append('_');
            }
            str = sbuf.toString();
        }
        return str;
    }

    public static String toCamelCase(String str) {
        StringBuilder buf = new StringBuilder();
        boolean lastWasDot = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '.') {
                lastWasDot = true;
                continue;
            }
            if (lastWasDot) {
                buf.append(Character.toUpperCase(c));
                lastWasDot = false;
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String camelCaseToDelimited(String str, String delimiter) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                if (delimiter != null) {
                    buf.append(delimiter);
                }
                c = Character.toLowerCase(c);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static boolean isAllDigits(String str, boolean whitespaceAllowed) {
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (Character.isDigit(c) || whitespaceAllowed && Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isAllDigits(String str) {
        return StringHelper.isAllDigits(str, false);
    }

    public static String trim(String s, int max) {
        if (s != null) {
            s = s.trim();
            if (max > 0 && s.length() > max) {
                s = s.substring(0, max);
            }
        }
        return s;
    }

    public static String trim(String s) {
        return StringHelper.trim(s, 0);
    }

    public static String trimRight(String str, char filler) {
        if (str == null) {
            str = "";
        } else if (!str.isEmpty()) {
            char c;
            int i = str.length();
            while (--i >= 0 && (c = str.charAt(i)) == filler) {
            }
            str = str.substring(0, i + 1);
        }
        return str;
    }

    public static String trimLeft(String str, char filler) {
        if (str == null) {
            str = "";
        } else {
            StringBuilder buf = new StringBuilder();
            boolean fillerFound = false;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!fillerFound && c == filler) continue;
                buf.append(c);
                fillerFound = true;
            }
            str = buf.toString();
        }
        return str;
    }

    public static String fillLeft(String str, int length, char filler) {
        int diff = length - (str == null ? 0 : str.length());
        if (diff > 0) {
            StringBuilder buf = new StringBuilder();
            while (diff-- > 0) {
                buf.append(filler);
            }
            if (str != null) {
                buf.append(str);
            }
            str = buf.toString();
        } else if (diff == 0 && str == null) {
            str = "";
        }
        return str;
    }

    public static String fillRight(String str, int length, char filler) {
        int diff = length - (str == null ? 0 : str.length());
        if (diff > 0) {
            StringBuilder buf = new StringBuilder();
            if (str != null) {
                buf.append(str);
            }
            while (diff-- > 0) {
                buf.append(filler);
            }
            str = buf.toString();
        } else if (diff == 0 && str == null) {
            str = "";
        }
        return str;
    }

    public static String firstBefore(String str, char delimiter) {
        int ndx;
        if (str != null && (ndx = str.indexOf(delimiter)) >= 0) {
            str = str.substring(0, ndx);
        }
        return str;
    }

    public static String lastAfter(String str, char delimiter) {
        int ndx;
        if (str != null && (ndx = str.lastIndexOf(delimiter)) >= 0) {
            str = str.substring(ndx + 1);
        }
        return str;
    }

    public static String firstLine(String str) {
        return StringHelper.firstBefore(str, '\n');
    }

    public static String toHexString(byte[] binaryData) {
        if (binaryData != null) {
            char[] text = new char[binaryData.length << 1];
            int j = 0;
            for (byte b : binaryData) {
                text[j++] = HEX_DIGITS[(b & 0xF0) >> 4];
                text[j++] = HEX_DIGITS[b & 0xF];
            }
            return new String(text);
        }
        return null;
    }

    public static byte[] toBytes(char c) {
        return new byte[]{(byte)(c & 0xFF), (byte)(c >> 8 & 0xFF)};
    }

    public static byte[] toBytes(char[] chars) {
        if (chars != null) {
            byte[] b = new byte[chars.length << 1];
            int j = 0;
            for (char c : chars) {
                b[j++] = (byte)(c & 0xFF);
                b[j++] = (byte)(c >> 8 & 0xFF);
            }
            return b;
        }
        return EMPTY_BYTES;
    }

    public static String hash(String algorithm, char[] salt, char[] input) {
        if (input != null) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                byte[] inputBytes = StringHelper.toBytes(input);
                if (salt != null && salt.length > 0 && input.length > 0) {
                    byte[] saltyBytes = StringHelper.toBytes(salt);
                    byte[] saltyInputBytes = new byte[saltyBytes.length + inputBytes.length];
                    System.arraycopy(saltyBytes, 0, saltyInputBytes, 0, saltyBytes.length);
                    System.arraycopy(inputBytes, 0, saltyInputBytes, saltyBytes.length, inputBytes.length);
                    inputBytes = saltyInputBytes;
                }
                return StringHelper.toHexString(md.digest(inputBytes));
            }
            catch (NoSuchAlgorithmException e) {
                throw new TentackleRuntimeException("hashing failed", e);
            }
        }
        return null;
    }

    public static String objectToLoggableString(Object object) {
        if (object == null) {
            return "<null>";
        }
        if (object instanceof String) {
            String str = (String)object;
            StringBuilder buf = new StringBuilder();
            buf.append('\"');
            if (str.indexOf(10) >= 0) {
                buf.append(StringHelper.firstLine(str));
                buf.append("...");
            } else {
                buf.append(str);
            }
            buf.append('\"');
            return buf.toString();
        }
        if (maxLogCollectionSize > 0 && object instanceof Collection && ((Collection)object).size() > maxLogCollectionSize) {
            return "[" + ((Collection)object).size() + " items]";
        }
        return object.toString();
    }

    public static int countOccurrences(String str, char c) {
        int count = 0;
        if (str != null && str.length() > 0) {
            int ndx = 0;
            while (ndx >= 0) {
                if ((ndx = str.indexOf(c, ndx + 1)) <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static String objectArrayToString(Object[] objArray, String separator) {
        StringBuilder buf = new StringBuilder();
        if (objArray != null) {
            boolean addSeparator = false;
            for (Object obj : objArray) {
                if (addSeparator) {
                    buf.append(separator);
                } else {
                    addSeparator = true;
                }
                buf.append(StringHelper.objectToLoggableString(obj));
            }
        }
        return buf.toString();
    }

    public static char[] toCharArray(String str) {
        return str == null ? null : str.toCharArray();
    }

    public static void fill(char[] buf, char val) {
        if (buf != null) {
            Arrays.fill(buf, val);
        }
    }

    public static void blank(char[] buf) {
        StringHelper.fill(buf, ' ');
    }

    public static String toHTML(String text) {
        StringBuilder buf = new StringBuilder("<HTML>");
        if (text != null) {
            buf.append(text.replace("\n", "<BR>"));
        }
        buf.append("</HTML>");
        return buf.toString();
    }

    public static String removeTrailingText(String str, String ... trail) {
        if (str != null && trail != null) {
            for (String t : trail) {
                if (!str.endsWith(t)) continue;
                str = str.substring(0, str.length() - t.length());
                break;
            }
        }
        return str;
    }

    public static String toAsciiLetterOrDigit(String str) {
        if (str != null) {
            StringBuilder buf = new StringBuilder(StringNormalizer.getInstance().unDiacrit(str, false));
            boolean wasUnderscore = false;
            for (int i = 0; i < buf.length(); ++i) {
                char c = buf.charAt(i);
                if (!(c != '_' && (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9'))) {
                    if (wasUnderscore) {
                        buf.deleteCharAt(i--);
                        continue;
                    }
                    buf.setCharAt(i, '_');
                    wasUnderscore = true;
                    continue;
                }
                wasUnderscore = false;
            }
            return buf.toString();
        }
        return null;
    }

    public static String getPlatform() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            throw new TentackleRuntimeException("missing system property 'os.name'");
        }
        osName = osName.trim().toLowerCase(Locale.ROOT);
        StringBuilder buf = new StringBuilder();
        boolean isWindows = osName.contains("win");
        for (int i = 0; i < osName.length(); ++i) {
            char c = osName.charAt(i);
            if (Character.isLetter(c)) {
                buf.append(c);
                continue;
            }
            if (isWindows) break;
        }
        return buf.toString();
    }

    public static String getArchitecture() {
        String osArch = System.getProperty("os.arch");
        if (osArch == null) {
            throw new TentackleRuntimeException("missing system property 'os.arch'");
        }
        return osArch.trim().toLowerCase(Locale.ROOT);
    }

    public static String filterUpperCase(String str) {
        if (str != null) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!Character.isUpperCase(c)) continue;
                buf.append(c);
            }
            return buf.toString();
        }
        return null;
    }

    public static String evaluate(String str, Function<String, String> variableProvider) {
        return StringHelper.evaluateImpl(str, variableProvider, new HashSet<String>());
    }

    private static String evaluateImpl(String str, Function<String, String> variableProvider, Set<String> processedVariables) {
        StringBuilder buf = new StringBuilder();
        StringBuilder variableName = null;
        char varLead = '@';
        char defLead = '?';
        StringBuilder defaultValue = null;
        boolean quoted = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (quoted) {
                if (variableName == null) {
                    buf.append(c);
                } else if (defaultValue == null) {
                    variableName.append(c);
                } else {
                    defaultValue.append(c);
                }
                quoted = false;
                continue;
            }
            if (c == '\\') {
                quoted = true;
                continue;
            }
            if (variableName == null) {
                if (c == '$' || c == '@') {
                    if (i < str.length() - 1 && str.charAt(i + 1) == '{') {
                        variableName = new StringBuilder();
                        varLead = c;
                        ++i;
                        continue;
                    }
                    buf.append(c);
                    continue;
                }
                buf.append(c);
                continue;
            }
            if (c == '}') {
                String key = variableName.toString();
                String value = variableProvider.apply(key);
                if (!(value == null || defaultValue != null && defLead != '!' && StringHelper.isAllWhitespace(value))) {
                    HashSet<String> variableBranch;
                    if (varLead == '$' && (variableBranch = new HashSet<String>(processedVariables)).add(key)) {
                        value = StringHelper.evaluateImpl(value, variableProvider, variableBranch);
                    }
                    buf.append(value);
                } else if (defaultValue != null) {
                    buf.append((CharSequence)defaultValue);
                } else {
                    buf.append(varLead).append('{').append((CharSequence)variableName).append('}');
                }
                variableName = null;
                defaultValue = null;
                continue;
            }
            if ((c == '?' || c == '!') && defaultValue == null) {
                defaultValue = new StringBuilder();
                defLead = c;
                continue;
            }
            if (defaultValue == null) {
                variableName.append(c);
                continue;
            }
            defaultValue.append(c);
        }
        if (variableName != null) {
            buf.append(varLead).append('{').append((CharSequence)variableName);
            if (defaultValue != null) {
                buf.append(defLead).append((CharSequence)defaultValue);
            }
        }
        return buf.toString();
    }

    public static int levenshteinDistance(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        int[][] d = new int[s1.length() + 1][s2.length() + 1];
        for (int i1 = 0; i1 <= s1.length(); ++i1) {
            for (int i2 = 0; i2 <= s2.length(); ++i2) {
                d[i1][i2] = i1 == 0 ? i2 : (i2 == 0 ? i1 : Math.min(d[i1 - 1][i2 - 1] + (s1.charAt(i1 - 1) == s2.charAt(i2 - 1) ? 0 : 1), Math.min(d[i1 - 1][i2] + 1, d[i1][i2 - 1] + 1)));
            }
        }
        return d[s1.length()][s2.length()];
    }

    public static String startsWithAnyOf(String str, int offset, String ... prefixes) {
        if (str != null) {
            for (String prefix : prefixes) {
                if (!str.startsWith(prefix, offset)) continue;
                return prefix;
            }
        }
        return null;
    }

    public static String startsWithAnyOf(String str, String ... prefixes) {
        return StringHelper.startsWithAnyOf(str, 0, prefixes);
    }

    public static String endsWithAnyOf(String str, String ... suffixes) {
        if (str != null) {
            for (String suffix : suffixes) {
                if (!str.endsWith(suffix)) continue;
                return suffix;
            }
        }
        return null;
    }

    private StringHelper() {
    }
}

