/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import org.tentackle.common.DateHelper;
import org.tentackle.common.Freezable;
import org.tentackle.common.TentackleRuntimeException;

public class Timestamp
extends java.sql.Timestamp
implements Freezable {
    private static final long serialVersionUID = 1L;
    private boolean utc;
    private boolean frozen;

    public static Timestamp createFrozen(long epoch, int nanos) {
        Timestamp timestamp = new Timestamp(epoch);
        timestamp.setNanos(nanos);
        timestamp.freeze();
        return timestamp;
    }

    public static void setUTC(Timestamp timestamp, boolean utc) {
        if (timestamp != null) {
            timestamp.setUTC(utc);
        }
    }

    public static Timestamp valueOf(String str) {
        return new Timestamp(java.sql.Timestamp.valueOf(str).getTime());
    }

    public Timestamp(long time) {
        super(time);
    }

    public Timestamp() {
        this(System.currentTimeMillis());
    }

    @Override
    public Timestamp clone() {
        Timestamp timestamp = (Timestamp)super.clone();
        timestamp.frozen = false;
        return timestamp;
    }

    public void setUTC(boolean utc) {
        this.utc = utc;
    }

    public boolean isUTC() {
        return this.utc;
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    @Override
    public void setTime(long timestamp) {
        this.assertNotFrozen();
        super.setTime(timestamp);
    }

    @Override
    public void setNanos(int n) {
        this.assertNotFrozen();
        super.setNanos(n);
    }

    @Override
    @Deprecated
    public void setYear(int year) {
        this.assertNotFrozen();
        super.setYear(year);
    }

    @Override
    @Deprecated
    public void setMonth(int month) {
        this.assertNotFrozen();
        super.setMonth(month);
    }

    @Override
    @Deprecated
    public void setDate(int date) {
        this.assertNotFrozen();
        super.setDate(date);
    }

    @Override
    @Deprecated
    public void setHours(int hours) {
        this.assertNotFrozen();
        super.setHours(hours);
    }

    @Override
    @Deprecated
    public void setMinutes(int minutes) {
        this.assertNotFrozen();
        super.setMinutes(minutes);
    }

    @Override
    @Deprecated
    public void setSeconds(int seconds) {
        this.assertNotFrozen();
        super.setSeconds(seconds);
    }

    private void assertNotFrozen() {
        if (this.frozen) {
            throw new TentackleRuntimeException("timestamp is frozen");
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeBoolean(this.utc);
        if (this.utc) {
            Calendar calendar = DateHelper.toCalendar(this);
            s.writeShort(calendar.get(1));
            s.writeByte(calendar.get(2));
            s.writeByte(calendar.get(5));
            s.writeByte(calendar.get(11));
            s.writeByte(calendar.get(12));
            s.writeByte(calendar.get(13));
        } else {
            s.writeLong(this.getTime());
        }
        s.writeInt(this.getNanos());
        s.writeBoolean(this.frozen);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.utc = s.readBoolean();
        if (this.utc) {
            short year = s.readShort();
            byte month = s.readByte();
            byte day = s.readByte();
            byte hours = s.readByte();
            byte minutes = s.readByte();
            byte seconds = s.readByte();
            int nanos = s.readInt();
            Calendar cal = DateHelper.today();
            cal.set(year, month, day, hours, minutes, seconds);
            super.setTime(cal.getTimeInMillis());
            this.setNanos(nanos);
        } else {
            super.setTime(s.readLong());
            this.setNanos(s.readInt());
        }
        this.frozen = s.readBoolean();
    }
}

