/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.tentackle.common.LocaleProvider;
import org.tentackle.common.ParameterString;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;

public class I18NText
implements CharSequence,
Comparable<I18NText>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_PAR = "default";
    private final LinkedHashMap<Locale, String> textMap;
    private final Locale defaultLocale;

    public static I18NText valueOf(String text) {
        return new I18NText(text);
    }

    public I18NText() {
        this.textMap = new LinkedHashMap();
        this.defaultLocale = null;
    }

    public I18NText(String text) {
        this(LocaleProvider.getInstance().getLocale(), text);
    }

    public I18NText(Locale locale, String text) {
        this.textMap = new LinkedHashMap();
        this.defaultLocale = this.apply(locale, text, this.textMap, null);
    }

    public I18NText(ParameterString parameterString) {
        LocaleProvider localeProvider = LocaleProvider.getInstance();
        String parameter = parameterString.getParameter(DEFAULT_PAR);
        this.defaultLocale = parameter == null ? null : localeProvider.fromTag(parameter);
        this.textMap = new LinkedHashMap();
        for (String tag : parameterString.getParameterNames()) {
            Locale locale = localeProvider.fromTag(tag);
            if (locale == null || !localeProvider.isLocaleSupported(locale) || (parameter = parameterString.getParameter(tag)) == null) continue;
            this.textMap.put(localeProvider.getEffectiveLocale(locale), parameter);
        }
    }

    public I18NText with(Locale locale, String text) {
        LinkedHashMap withTextMap = (LinkedHashMap)this.textMap.clone();
        Locale withDefaultLocale = this.apply(locale, text, withTextMap, this.defaultLocale);
        return new I18NText(withTextMap, withDefaultLocale);
    }

    public I18NText with(String text) {
        return this.with(LocaleProvider.getInstance().getLocale(), text);
    }

    public String get(Locale locale) {
        LocaleProvider localeProvider = LocaleProvider.getInstance();
        String text = this.textMap.get(this.narrowLocale(localeProvider.getEffectiveLocale(locale)));
        if (text == null) {
            text = this.defaultLocale != null ? this.textMap.get(this.defaultLocale) : this.textMap.get(localeProvider.getFallbackLocale());
        }
        return text;
    }

    public String get() {
        return this.get(LocaleProvider.getInstance().getLocale());
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public Map<Locale, String> getTranslations() {
        return Map.copyOf(this.textMap);
    }

    public ParameterString toParameterString() {
        ParameterString ps = new ParameterString();
        LocaleProvider localeProvider = LocaleProvider.getInstance();
        if (this.defaultLocale != null) {
            ps.setParameter(DEFAULT_PAR, localeProvider.toTag(this.defaultLocale));
        }
        for (Map.Entry<Locale, String> entry : this.textMap.entrySet()) {
            ps.setParameter(localeProvider.toTag(entry.getKey()), entry.getValue());
        }
        return ps;
    }

    public boolean isVacant() {
        return this.textMap.isEmpty();
    }

    @Override
    public int length() {
        String text = this.get();
        return text == null ? 0 : text.length();
    }

    @Override
    public boolean isEmpty() {
        return this.isVacant() || this.length() == 0;
    }

    @Override
    public char charAt(int index) {
        String text = this.get();
        if (text != null) {
            return text.charAt(index);
        }
        throw new IndexOutOfBoundsException("no translation for the current locale");
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        String text = this.get();
        return text == null ? "".subSequence(start, end) : text.subSequence(start, end);
    }

    @Override
    public IntStream chars() {
        final String text = this.get();
        final int length = text == null ? 0 : text.length();
        return StreamSupport.intStream(() -> {
            class CharIterator
            implements PrimitiveIterator.OfInt {
                int cur = 0;

                CharIterator() {
                }

                @Override
                public boolean hasNext() {
                    return this.cur < length;
                }

                @Override
                public int nextInt() {
                    if (this.hasNext()) {
                        return text.charAt(this.cur++);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void forEachRemaining(IntConsumer block) {
                    while (this.cur < length) {
                        block.accept(text.charAt(this.cur));
                        ++this.cur;
                    }
                }
            }
            return Spliterators.spliterator(new CharIterator(), (long)length, 16);
        }, 16464, false);
    }

    @Override
    public IntStream codePoints() {
        final String text = this.get();
        final int length = text == null ? 0 : text.length();
        return StreamSupport.intStream(() -> {
            class CodePointIterator
            implements PrimitiveIterator.OfInt {
                int cur = 0;

                CodePointIterator() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void forEachRemaining(IntConsumer block) {
                    int i = this.cur;
                    try {
                        while (i < length) {
                            char c1;
                            if (!Character.isHighSurrogate(c1 = text.charAt(i++)) || i >= length) {
                                block.accept(c1);
                                continue;
                            }
                            char c2 = text.charAt(i);
                            if (Character.isLowSurrogate(c2)) {
                                ++i;
                                block.accept(Character.toCodePoint(c1, c2));
                                continue;
                            }
                            block.accept(c1);
                        }
                    }
                    finally {
                        this.cur = i;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.cur < length;
                }

                @Override
                public int nextInt() {
                    char c2;
                    char c1;
                    if (this.cur >= length) {
                        throw new NoSuchElementException();
                    }
                    if (Character.isHighSurrogate(c1 = text.charAt(this.cur++)) && this.cur < length && Character.isLowSurrogate(c2 = text.charAt(this.cur))) {
                        ++this.cur;
                        return Character.toCodePoint(c1, c2);
                    }
                    return c1;
                }
            }
            return Spliterators.spliteratorUnknownSize(new CodePointIterator(), 16);
        }, 16, false);
    }

    @Override
    public int compareTo(I18NText o) {
        if (this == o) {
            return 0;
        }
        String text = this.get();
        String oText = o.get();
        if (text == null) {
            return oText == null ? 0 : -1;
        }
        return oText == null ? 1 : text.compareTo(oText);
    }

    @Override
    public String toString() {
        return this.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        I18NText i18NText = (I18NText)o;
        if (!this.textMap.equals(i18NText.textMap)) {
            return false;
        }
        return Objects.equals(this.defaultLocale, i18NText.defaultLocale);
    }

    public int hashCode() {
        int result = this.textMap.hashCode();
        result = 31 * result + (this.defaultLocale != null ? this.defaultLocale.hashCode() : 0);
        return result;
    }

    protected I18NText(LinkedHashMap<Locale, String> textMap, Locale defaultLocale) {
        this.textMap = textMap;
        this.defaultLocale = defaultLocale;
    }

    protected Locale apply(Locale locale, String text, LinkedHashMap<Locale, String> withTextMap, Locale withDefaultLocale) {
        LocaleProvider localeProvider = LocaleProvider.getInstance();
        if (!localeProvider.isLocaleSupported(locale)) {
            throw new TentackleRuntimeException("unsupported locale: " + locale);
        }
        locale = this.narrowLocale(localeProvider.getEffectiveLocale(locale));
        if (StringHelper.isAllWhitespace(text)) {
            withTextMap.remove(locale);
            if (locale.equals(withDefaultLocale)) {
                withDefaultLocale = null;
                if (!withTextMap.isEmpty()) {
                    withDefaultLocale = localeProvider.getEffectiveLocale(withTextMap.keySet().iterator().next());
                }
            }
        } else {
            if (withDefaultLocale == null) {
                if (withTextMap.isEmpty() && !locale.equals(localeProvider.getFallbackLocale())) {
                    withDefaultLocale = localeProvider.getEffectiveLocale(locale);
                }
            } else if (locale.equals(localeProvider.getFallbackLocale())) {
                withDefaultLocale = null;
            }
            withTextMap.put(locale, text);
        }
        return withDefaultLocale;
    }

    protected Locale narrowLocale(Locale locale) {
        if (!locale.getVariant().isEmpty() || !locale.getCountry().isEmpty()) {
            locale = new Locale(locale.getLanguage());
        }
        return locale;
    }
}

