/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.StringTokenizer;
import java.util.function.Function;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.tentackle.common.CryptorHolder;
import org.tentackle.common.Settings;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;

public class Cryptor
implements Function<String, String> {
    private final SecretKey key;
    private final Cipher cipher;

    public static Cryptor getInstance() {
        return CryptorHolder.INSTANCE;
    }

    public static Cryptor getInstanceSafely() {
        Cryptor cryptor = Cryptor.getInstance();
        if (cryptor == null) {
            throw new TentackleRuntimeException("missing application specific Cryptor");
        }
        return cryptor;
    }

    public Cryptor(byte[] salt, char[] passphrase, int iterations, int keyStrength) {
        SecretKey tmpKey;
        SecretKeyFactory factory = this.getSecretKeyFactory();
        PBEKeySpec spec = new PBEKeySpec(passphrase, salt, iterations, keyStrength);
        try {
            tmpKey = factory.generateSecret(spec);
        }
        catch (InvalidKeySpecException e1) {
            throw new TentackleRuntimeException("generating temporary key failed", e1);
        }
        StringHelper.blank(passphrase);
        Arrays.fill(salt, (byte)0);
        this.key = this.createSecretKeySpec(tmpKey.getEncoded());
        this.cipher = this.getCipher();
    }

    public Cryptor(byte[] salt, char[] passphrase) {
        this(salt, passphrase, 1024, 256);
    }

    public Cryptor(String salt, String passphrase) {
        this(salt.getBytes(Settings.getEncodingCharset()), passphrase.toCharArray());
    }

    public byte[] encrypt(byte[] data) {
        try {
            this.cipher.init(1, this.key);
            return this.cipher.doFinal(data);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new TentackleRuntimeException("encryption failed", e);
        }
    }

    public byte[] encrypt(byte[] data, int offset, int length) {
        try {
            this.cipher.init(1, this.key);
            return this.cipher.doFinal(data, offset, length);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new TentackleRuntimeException("encryption failed", e);
        }
    }

    public byte[] decrypt(byte[] encryptedData) {
        try {
            this.cipher.init(2, this.key);
            return this.cipher.doFinal(encryptedData);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new TentackleRuntimeException("decryption failed", e);
        }
    }

    public String encrypt64(byte[] data) {
        return Base64.getEncoder().encodeToString(this.encrypt(data));
    }

    public byte[] encrypt(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Settings.getEncodingCharset().encode(charBuffer);
        byte[] data = byteBuffer.array();
        byte[] encryptedData = this.encrypt(data, 0, byteBuffer.remaining());
        Arrays.fill(charBuffer.array(), ' ');
        Arrays.fill(data, (byte)0);
        return encryptedData;
    }

    public String encrypt64(char[] chars) {
        return Base64.getEncoder().encodeToString(this.encrypt(chars));
    }

    public String encrypt64(String text) {
        return this.encrypt64(text.getBytes(Settings.getEncodingCharset()));
    }

    public char[] decryptToChars(byte[] encryptedData) {
        return this.toChars(this.decrypt(encryptedData));
    }

    public byte[] decrypt64ToBytes(String encryptedText) {
        return this.decrypt(Base64.getDecoder().decode(encryptedText.getBytes(Settings.getEncodingCharset())));
    }

    public char[] decrypt64ToChars(String encryptedText) {
        return this.toChars(this.decrypt64ToBytes(encryptedText));
    }

    public String decrypt64(String encryptedText) {
        return new String(this.decrypt64ToBytes(encryptedText), Settings.getEncodingCharset());
    }

    @Override
    public String apply(String s) {
        return this.encrypt64(s);
    }

    public String deriveURL(String url, String[] protocols) {
        for (String protocol : protocols) {
            StringTokenizer stok;
            if (!url.startsWith(protocol)) continue;
            int ndx = url.indexOf("=~");
            if (ndx < 0 || !(stok = new StringTokenizer(url.substring(ndx + 2), "&")).hasMoreTokens()) break;
            url = this.decrypt64(stok.nextToken());
            break;
        }
        return url;
    }

    protected SecretKeyFactory getSecretKeyFactory() {
        try {
            return SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new TentackleRuntimeException("cannot load key factory", e);
        }
    }

    protected SecretKeySpec createSecretKeySpec(byte[] key) {
        return new SecretKeySpec(key, "AES");
    }

    protected Cipher getCipher() {
        try {
            return Cipher.getInstance("AES");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new TentackleRuntimeException("creating cipher failed", e);
        }
    }

    private char[] toChars(byte[] data) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        CharBuffer charBuffer = Settings.getEncodingCharset().decode(byteBuffer);
        char[] chars = new char[charBuffer.remaining()];
        charBuffer.get(chars);
        Arrays.fill(data, (byte)0);
        Arrays.fill(byteBuffer.array(), (byte)0);
        Arrays.fill(charBuffer.array(), ' ');
        return chars;
    }
}

