/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.lang.module.ModuleDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.tentackle.common.ModuleHook;
import org.tentackle.common.TentackleRuntimeException;

public final class ModuleInfo {
    private final ModuleHook hook;
    private final String urlPath;
    private final Module module;
    private final Set<String> requiredModuleNames;
    private int ordinal;
    private boolean visited;

    public ModuleInfo(ModuleHook hook) {
        this.hook = hook;
        this.urlPath = hook.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        this.module = hook.getClass().getModule();
        if (this.module == null || !this.module.isNamed()) {
            throw new TentackleRuntimeException(hook.getClass() + " does not belong to a named module");
        }
        this.requiredModuleNames = new HashSet<String>();
        for (ModuleDescriptor.Requires req : this.module.getDescriptor().requires()) {
            this.requiredModuleNames.add(req.name());
        }
    }

    public ModuleHook getHook() {
        return this.hook;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public Module getModule() {
        return this.module;
    }

    public Set<String> getRequiredModuleNames() {
        return this.requiredModuleNames;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    void setVisited(boolean visited) {
        this.visited = visited;
    }

    boolean isVisited() {
        return this.visited;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.module.getName()).append(" {");
        boolean needComma = false;
        for (String subName : this.requiredModuleNames) {
            if (needComma) {
                buf.append(", ");
            } else {
                needComma = true;
            }
            buf.append(subName);
        }
        buf.append('}');
        if (this.ordinal != 0) {
            buf.append(" [").append(this.ordinal).append(']');
        }
        return buf.toString();
    }
}

