/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.tentackle.common.CommonCommonBundle;
import org.tentackle.common.TentackleRuntimeException;

public final class BasicStringHelper {
    public static final String[] javaReservedWords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

    public static String toUpper(String str) {
        if (str != null) {
            str = str.toUpperCase();
        }
        return str;
    }

    public static String toLower(String str) {
        if (str != null) {
            str = str.toLowerCase();
        }
        return str;
    }

    public static String firstToUpper(String str) {
        if (str != null && str.length() > 0) {
            StringBuilder buf = new StringBuilder(str);
            buf.deleteCharAt(0);
            buf.insert(0, Character.toUpperCase(str.charAt(0)));
            return buf.toString();
        }
        return null;
    }

    public static String firstToLower(String str) {
        if (str != null && str.length() > 0) {
            StringBuilder buf = new StringBuilder(str);
            buf.deleteCharAt(0);
            buf.insert(0, Character.toLowerCase(str.charAt(0)));
            return buf.toString();
        }
        return null;
    }

    public static String getPlainClassName(String className) {
        int ndx = className.indexOf(60);
        if (ndx > 0) {
            return className.substring(0, ndx).trim();
        }
        return className;
    }

    public static String getContinuedLine(String line) {
        int len;
        if (line != null && (len = line.length()) > 0 && line.charAt(len - 1) == '\\') {
            int ndx = len - 1;
            int slashCount = 1;
            while (--ndx >= 0 && line.charAt(ndx) == '\\') {
                ++slashCount;
            }
            if (slashCount & true) {
                return line.substring(0, len - 1);
            }
        }
        return null;
    }

    public static String toDoubleQuotes(String str) {
        StringBuilder buf = new StringBuilder();
        buf.append('\"');
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c == '\"' || c == '\\') {
                    buf.append('\\');
                } else if (Character.isISOControl(c)) {
                    c = ' ';
                }
                buf.append(c);
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String parseString(String str) {
        StringBuilder buf = new StringBuilder();
        if (str != null && str.length() > 0) {
            char quoteChar = str.charAt(0);
            if (quoteChar != '\"' && quoteChar != '\'') {
                quoteChar = '\u0000';
            }
            if (quoteChar != '\u0000') {
                char lastChar = str.charAt(str.length() - 1);
                if (lastChar != quoteChar || str.length() < 2) {
                    throw new TentackleRuntimeException("String <" + str + "> contains unbalanced quotes");
                }
                str = str.substring(1, str.length() - 1);
            }
            boolean escaped = false;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (escaped) {
                    if (c == 'n') {
                        buf.append('\n');
                    } else if (c == 'r') {
                        buf.append('\r');
                    } else if (c == 't') {
                        buf.append('\t');
                    } else if (c == 'f') {
                        buf.append('\f');
                    } else {
                        buf.append(c);
                    }
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                buf.append(c);
            }
        }
        return buf.toString();
    }

    public static List<String> split(String str, String delimiters) {
        ArrayList<String> parts = new ArrayList<String>();
        if (str != null) {
            StringBuilder part = null;
            boolean escaped = false;
            char quoteChar = '\u0000';
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (escaped) {
                    if (c == 'n') {
                        part.append('\n');
                    } else if (c == 'r') {
                        part.append('\r');
                    } else if (c == 't') {
                        part.append('\t');
                    } else if (c == 'f') {
                        part.append('\f');
                    } else {
                        part.append(c);
                    }
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    if (part != null) continue;
                    part = new StringBuilder();
                    continue;
                }
                if (c == '\'' || c == '\"') {
                    if (part == null) {
                        part = new StringBuilder();
                        part.append(c);
                        quoteChar = c;
                        continue;
                    }
                    if (quoteChar != '\u0000' && quoteChar != c) {
                        part.append(c);
                        continue;
                    }
                    part.append(c);
                    parts.add(part.toString());
                    part = null;
                    quoteChar = '\u0000';
                    continue;
                }
                if (delimiters.indexOf(c) >= 0) {
                    if (quoteChar == '\u0000') {
                        if (part == null) continue;
                        parts.add(part.toString());
                        part = null;
                        continue;
                    }
                    part.append(c);
                    continue;
                }
                if (part == null) {
                    part = new StringBuilder();
                }
                part.append(c);
            }
            if (part != null) {
                parts.add(part.toString());
            }
        }
        return parts;
    }

    public static boolean isValidJavaClassName(String className) {
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex > 0) {
            String packageName = className.substring(0, dotIndex);
            className = className.substring(dotIndex + 1);
            if (!BasicStringHelper.isValidJavaPackageName(packageName)) {
                return false;
            }
        }
        if (className.length() < 1) {
            return false;
        }
        char firstChar = className.charAt(0);
        if (!Character.isAlphabetic(firstChar) || !Character.isUpperCase(firstChar)) {
            return false;
        }
        for (int pos = 0; pos < className.length(); ++pos) {
            char c = className.charAt(pos);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaPackageName(String packageName) {
        boolean lastWasDot = true;
        for (int pos = 0; pos < packageName.length(); ++pos) {
            char c = packageName.charAt(pos);
            if (c == '.') {
                lastWasDot = true;
                continue;
            }
            if (lastWasDot) {
                lastWasDot = false;
                if (!Character.isDigit(c)) continue;
                return false;
            }
            if (Character.isDigit(c) || !Character.isUpperCase(c) && (Character.isAlphabetic(c) || c == '_')) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        char[] c = str.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFromResource(String resourceName) throws IOException {
        InputStream is = null;
        try {
            String line;
            is = BasicStringHelper.class.getResourceAsStream(resourceName);
            if (is == null && (is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName)) == null) {
                throw new FileNotFoundException("no such resource: " + resourceName);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder buf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            String string = buf.toString();
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isAllWhitespace(String str) {
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isReservedWord(String word) {
        if (word != null) {
            for (String rw : javaReservedWords) {
                if (!rw.equals(word)) continue;
                return true;
            }
        }
        return false;
    }

    public static String digitToString(Character digit) {
        return CommonCommonBundle.getString(String.valueOf(digit));
    }

    private BasicStringHelper() {
    }
}

