/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tentackle.common.BasicStringHelper;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.ServiceFinder;
import org.tentackle.common.TentackleRuntimeException;

@Service(value=ServiceFinder.class)
public class DefaultServiceFinder
implements ServiceFinder {
    private ClassLoader loader;
    private String servicePath;
    private Map<String, Map<String, URL>> serviceMap;
    private Map<String, Collection<Class<?>>> classMap;

    public DefaultServiceFinder(ClassLoader loader, String servicePath) {
        this.loader = loader;
        if (servicePath == null) {
            this.servicePath = "META-INF/services/";
        } else {
            while (servicePath.startsWith("/")) {
                servicePath = servicePath.substring(1, servicePath.length());
            }
            if (!servicePath.endsWith("/")) {
                servicePath = servicePath + "/";
            }
            this.servicePath = servicePath;
        }
        this.serviceMap = new HashMap<String, Map<String, URL>>();
        this.classMap = new HashMap();
    }

    public DefaultServiceFinder(String servicePath) {
        this(Thread.currentThread().getContextClassLoader(), servicePath);
    }

    public DefaultServiceFinder() {
        this(null);
    }

    @Override
    public Enumeration<URL> findServiceURLs(String serviceName) {
        try {
            String fullName = this.servicePath + serviceName;
            return this.loader == null ? ClassLoader.getSystemResources(fullName) : this.loader.getResources(fullName);
        }
        catch (IOException iox) {
            throw new TentackleRuntimeException("loading service information failed", iox);
        }
    }

    @Override
    public Map<String, URL> findServiceConfigurations(String serviceName) {
        Map<String, URL> services = this.serviceMap.get(serviceName);
        if (services == null) {
            services = new LinkedHashMap<String, URL>();
            Enumeration<URL> urls = this.findServiceURLs(serviceName);
            while (urls.hasMoreElements()) {
                this.parseURL(urls.nextElement(), serviceName, services);
            }
            this.serviceMap.put(serviceName, services);
        }
        return services;
    }

    @Override
    public Map.Entry<String, URL> findFirstServiceConfiguration(String serviceName) {
        Map<String, URL> services = this.findServiceConfigurations(serviceName);
        if (services.isEmpty()) {
            throw new TentackleRuntimeException("service '" + serviceName + "' not found");
        }
        return services.entrySet().iterator().next();
    }

    @Override
    public Map.Entry<String, URL> findUniqueServiceConfiguration(String serviceName) {
        Map<String, URL> services = this.findServiceConfigurations(serviceName);
        if (services.isEmpty()) {
            throw new TentackleRuntimeException("service '" + serviceName + "' not found");
        }
        if (services.size() > 1) {
            String msg = "service '" + serviceName + "' defined more than once: ";
            boolean needComma = false;
            for (Map.Entry<String, URL> entry : services.entrySet()) {
                if (needComma) {
                    msg = msg + ", ";
                }
                msg = msg + entry.getKey() + " in " + entry.getValue();
                needComma = true;
            }
            throw new TentackleRuntimeException(msg);
        }
        return services.entrySet().iterator().next();
    }

    @Override
    public <T> Collection<Class<T>> findServiceProviders(Class<T> service) throws ClassNotFoundException {
        String serviceName = service.getName();
        Collection<Class<T>> serviceImplClasses = this.classMap.get(serviceName);
        if (serviceImplClasses == null) {
            serviceImplClasses = new ArrayList<Class<T>>();
            for (Map.Entry<String, URL> entry : this.findServiceConfigurations(serviceName).entrySet()) {
                String serviceImplName = entry.getKey();
                Class<?> provider = Class.forName(serviceImplName);
                this.checkProvider(provider, service, entry.getValue());
                serviceImplClasses.add(provider);
            }
            this.classMap.put(serviceName, serviceImplClasses);
        }
        return serviceImplClasses;
    }

    @Override
    public <T> Class<T> findFirstServiceProvider(Class<T> service) throws ClassNotFoundException {
        Map.Entry<String, URL> entry = this.findFirstServiceConfiguration(service.getName());
        Class<?> provider = Class.forName(entry.getKey());
        this.checkProvider(provider, service, entry.getValue());
        return provider;
    }

    @Override
    public <T> Class<T> findUniqueServiceProvider(Class<T> service) throws ClassNotFoundException {
        Map.Entry<String, URL> entry = this.findUniqueServiceConfiguration(service.getName());
        Class<?> provider = Class.forName(entry.getKey());
        this.checkProvider(provider, service, entry.getValue());
        return provider;
    }

    @Override
    public Map<String, String> createNameMap(String serviceName) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (Map.Entry<String, URL> entry : ServiceFactory.getServiceFinder("META-INF/mapped-services/").findServiceConfigurations(serviceName).entrySet()) {
            String configuration = entry.getKey();
            List<String> parts = BasicStringHelper.split(configuration, ":= ");
            if (parts.size() != 2) {
                throw new TentackleRuntimeException("invalid service configuration '" + configuration + "' in " + entry.getValue());
            }
            nameMap.putIfAbsent(parts.get(1), parts.get(0));
        }
        return nameMap;
    }

    @Override
    public Map<String, Set<String>> createNameMapToAll(String serviceName) {
        HashMap<String, Set<String>> nameMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, URL> entry : ServiceFactory.getServiceFinder("META-INF/mapped-services/").findServiceConfigurations(serviceName).entrySet()) {
            String configuration = entry.getKey();
            List<String> parts = BasicStringHelper.split(configuration, ":= ");
            if (parts.size() != 2) {
                throw new TentackleRuntimeException("invalid service configuration '" + configuration + "' in " + entry.getValue());
            }
            String key = parts.get(1);
            HashSet<String> serviceList = (HashSet<String>)nameMap.get(key);
            if (serviceList == null) {
                serviceList = new HashSet<String>();
                nameMap.put(key, serviceList);
            }
            serviceList.add(parts.get(0));
        }
        return nameMap;
    }

    protected void parseURL(URL url, String serviceName, Map<String, URL> services) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
            while ((line = reader.readLine()) != null) {
                URL otherUrl;
                if ((line = this.normalizeLine(line)) == null || (otherUrl = services.put(line, url)) == null) continue;
                String urlText = url.toString();
                String otherUrlText = otherUrl.toString();
                int urlNdx = urlText.lastIndexOf(this.servicePath);
                int otherUrlNdx = otherUrlText.lastIndexOf(this.servicePath);
                if (urlNdx > 0 && otherUrlNdx > 0 && urlText.endsWith(otherUrlText.substring(otherUrlNdx))) continue;
                throw new TentackleRuntimeException("service " + serviceName + " defined more than once! (" + otherUrl + " and " + url + ")");
            }
        }
        catch (IOException iox) {
            throw new TentackleRuntimeException("error reading configuration from " + url, iox);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iox) {
                throw new TentackleRuntimeException("error closing configuration file", iox);
            }
        }
    }

    protected String normalizeLine(String line) {
        boolean quoteFound = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (quoteFound) {
                if (c != '#') {
                    buf.append('\\');
                }
                buf.append(c);
                quoteFound = false;
                continue;
            }
            if (c == '\\') {
                quoteFound = true;
                continue;
            }
            if (c == '#') break;
            buf.append(c);
        }
        return (line = buf.toString().trim()).isEmpty() ? null : line;
    }

    private void checkProvider(Class<?> provider, Class<?> service, URL url) {
        if (!service.isAssignableFrom(provider)) {
            throw new TentackleRuntimeException("provider '" + provider + "' does not implement '" + service + "', configured in " + url);
        }
    }
}

