/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

public final class ExceptionHelper {
    public static <T extends Throwable> T extractException(Class<T> type, boolean first, Throwable headOfChain) {
        Throwable ex = null;
        while (headOfChain != null) {
            if (type.isAssignableFrom(headOfChain.getClass())) {
                ex = headOfChain;
                if (first) break;
            }
            headOfChain = headOfChain.getCause();
        }
        return (T)ex;
    }

    public static Throwable extractException(boolean first, Throwable headOfChain, Class<? extends Throwable> ... types) {
        for (Class<? extends Throwable> type : types) {
            Throwable t = ExceptionHelper.extractException(type, first, headOfChain);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static String concatenateMessages(Throwable headOfChain) {
        StringBuilder buf = new StringBuilder();
        if (headOfChain.getMessage() != null) {
            buf.append(headOfChain.getMessage());
        }
        for (Throwable cause = headOfChain.getCause(); cause != null; cause = cause.getCause()) {
            String subMsg = cause.getMessage();
            if (subMsg == null || buf.indexOf(subMsg) >= 0) continue;
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(subMsg);
        }
        return buf.toString();
    }

    private ExceptionHelper() {
    }
}

