/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tentackle.common.DefaultServiceFinder;
import org.tentackle.common.ServiceFinder;
import org.tentackle.common.TentackleRuntimeException;

public class ServiceFactory {
    private static final ServiceFactory INSTANCE = new ServiceFactory();
    private Class<? extends ServiceFinder> serviceFinderClass;
    private final Map<Key, ServiceFinder> finderMap;

    private ServiceFactory() {
        try {
            this.serviceFinderClass = new DefaultServiceFinder().findFirstServiceProvider(ServiceFinder.class);
        }
        catch (Exception ex) {
            Logger.getLogger(ServiceFactory.class.getName()).log(Level.WARNING, "{0} -> fallback to {1}", new Object[]{ex.getMessage(), DefaultServiceFinder.class.getName()});
            this.serviceFinderClass = DefaultServiceFinder.class;
        }
        this.finderMap = new ConcurrentHashMap<Key, ServiceFinder>();
    }

    private ServiceFinder getServiceFinderImpl(ClassLoader loader, String servicePath) {
        if (loader == null) {
            throw new IllegalArgumentException("loader must not be null");
        }
        if (servicePath == null) {
            throw new IllegalArgumentException("service path must not be null");
        }
        Key key = new Key(loader, servicePath);
        ServiceFinder finder = this.finderMap.get(key);
        if (finder == null) {
            try {
                finder = this.serviceFinderClass.getConstructor(ClassLoader.class, String.class).newInstance(loader, servicePath);
                this.finderMap.put(key, finder);
            }
            catch (Exception ex) {
                throw new TentackleRuntimeException("cannot instantiate service finder", ex);
            }
        }
        return finder;
    }

    private ServiceFinder getServiceFinderImpl(String servicePath) {
        return this.getServiceFinderImpl(Thread.currentThread().getContextClassLoader(), servicePath);
    }

    private ServiceFinder getServiceFinderImpl() {
        return this.getServiceFinderImpl("META-INF/services/");
    }

    public static ServiceFinder getServiceFinder(ClassLoader loader, String servicePath) {
        return INSTANCE.getServiceFinderImpl(loader, servicePath);
    }

    public static ServiceFinder getServiceFinder(String servicePath) {
        return INSTANCE.getServiceFinderImpl(servicePath);
    }

    public static ServiceFinder getServiceFinder() {
        return INSTANCE.getServiceFinderImpl();
    }

    public static <T> Class<T> createServiceClass(Class<T> serviceClass) {
        try {
            return INSTANCE.getServiceFinderImpl().findFirstServiceProvider(serviceClass);
        }
        catch (Exception ex) {
            throw new TentackleRuntimeException("cannot create service class for " + serviceClass, ex);
        }
    }

    public static <T> T createService(Class<T> serviceClass) {
        try {
            return ServiceFactory.createServiceClass(serviceClass).newInstance();
        }
        catch (Exception ex) {
            throw new TentackleRuntimeException("cannot create instance for " + serviceClass, ex);
        }
    }

    public static <T> T createService(Class<T> serviceClass, Class<? extends T> defaultClass) {
        try {
            return ServiceFactory.createService(serviceClass);
        }
        catch (TentackleRuntimeException re) {
            try {
                Logger.getLogger(ServiceFactory.class.getName()).log(Level.WARNING, "{0} -> creating default {1}", new Object[]{re.getMessage(), defaultClass.getName()});
                return defaultClass.newInstance();
            }
            catch (Exception ex) {
                throw new TentackleRuntimeException("cannot create default instance " + defaultClass + " for " + serviceClass, ex);
            }
        }
    }

    private static final class Key {
        private final ClassLoader loader;
        private final String servicePath;

        private Key(ClassLoader loader, String servicePath) {
            this.loader = loader;
            this.servicePath = servicePath;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!(this.loader == other.loader || this.loader != null && this.loader.equals(other.loader))) {
                return false;
            }
            return !(this.servicePath != null ? !this.servicePath.equals(other.servicePath) : other.servicePath != null);
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + (this.loader != null ? this.loader.hashCode() : 0);
            hash = 89 * hash + (this.servicePath != null ? this.servicePath.hashCode() : 0);
            return hash;
        }
    }
}

