/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;

public class Timestamp
extends java.sql.Timestamp {
    private static final long serialVersionUID = 2745179027874758503L;
    private boolean utc;
    private transient Calendar cal;

    public Timestamp(long time) {
        super(time);
    }

    public Timestamp() {
        this(System.currentTimeMillis());
    }

    public void setUTC(boolean utc) {
        this.utc = utc;
    }

    public boolean isUTC() {
        return this.utc;
    }

    public Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = Calendar.getInstance();
            this.cal.setTime(this);
        }
        return this.cal;
    }

    @Override
    public void setTime(long timestamp) {
        super.setTime(timestamp);
        this.cal = null;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeBoolean(this.utc);
        if (this.utc) {
            s.writeShort(this.getCalendar().get(1));
            s.writeByte(this.getCalendar().get(2));
            s.writeByte(this.getCalendar().get(5));
            s.writeByte(this.getCalendar().get(11));
            s.writeByte(this.getCalendar().get(12));
            s.writeByte(this.getCalendar().get(13));
            s.writeInt(this.getNanos());
        } else {
            s.writeLong(this.getTime());
            s.writeInt(this.getNanos());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.utc = s.readBoolean();
        if (this.utc) {
            short year = s.readShort();
            byte month = s.readByte();
            byte day = s.readByte();
            byte hours = s.readByte();
            byte minutes = s.readByte();
            byte seconds = s.readByte();
            int nanos = s.readInt();
            this.cal = Calendar.getInstance();
            this.cal.set(year, month, day, hours, minutes, seconds);
            super.setTime(this.cal.getTimeInMillis());
            this.setNanos(nanos);
        } else {
            super.setTime(s.readLong());
            this.setNanos(s.readInt());
        }
    }
}

