/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

public class ServiceFinderKey {
    private final ClassLoader classLoader;
    private final String servicePath;

    public ServiceFinderKey(ClassLoader classLoader, String servicePath) {
        if (classLoader == null) {
            throw new IllegalArgumentException("classloader must not be null");
        }
        if (servicePath == null) {
            throw new IllegalArgumentException("service path must not be null");
        }
        this.classLoader = classLoader;
        this.servicePath = servicePath;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getServicePath() {
        return this.servicePath;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceFinderKey other = (ServiceFinderKey)obj;
        if (!(this.classLoader == other.classLoader || this.classLoader != null && this.classLoader.equals(other.classLoader))) {
            return false;
        }
        return !(this.servicePath != null ? !this.servicePath.equals(other.servicePath) : other.servicePath != null);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.classLoader != null ? this.classLoader.hashCode() : 0);
        hash = 89 * hash + (this.servicePath != null ? this.servicePath.hashCode() : 0);
        return hash;
    }
}

