/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Binary<T>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5853122168291704220L;
    public static int bufSize = 1024;
    private byte[] data;
    private int length;
    private transient T object;

    public Binary(T object) throws IOException {
        this.setObject(object);
    }

    public Binary(byte[] data) {
        this.setData(data);
    }

    public Binary() {
    }

    public Binary<T> clone() {
        Binary binary;
        try {
            binary = (Binary)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        if (binary.data != null) {
            binary.data = new byte[this.length];
            System.arraycopy(this.data, 0, binary.data, 0, this.length);
        }
        return binary;
    }

    public static Binary<?> createBinary(InputStream stream, int bufSize) throws IOException {
        int count;
        if (stream == null) {
            return null;
        }
        Binary b = new Binary();
        if (bufSize <= 0) {
            bufSize = Binary.bufSize;
        }
        b.data = new byte[bufSize];
        while ((count = stream.read(b.data, b.length, bufSize - b.length)) >= 0) {
            b.length += count;
            if (b.length != bufSize) continue;
            byte[] oldData = b.data;
            b.data = new byte[bufSize <<= 1];
            System.arraycopy(oldData, 0, b.data, 0, b.length);
        }
        stream.close();
        return b.length == 0 ? null : b;
    }

    public int getLength() {
        return this.length;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public T getObject() throws IOException, ClassNotFoundException {
        if (this.object == null && this.data != null) {
            try (ObjectInputStream is = new ObjectInputStream(this.getInputStream());){
                this.object = is.readObject();
            }
        }
        return this.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setObject(T object) throws IOException {
        this.object = object;
        if (object == null) {
            this.data = null;
            this.length = 0;
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream os = null;){
                os = new ObjectOutputStream(bos);
                os.writeObject(object);
                os.flush();
                this.data = bos.toByteArray();
                this.length = bos.size();
            }
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.object = null;
        this.length = data == null ? 0 : data.length;
    }
}

