/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public final class ExceptionHelper {
    public static <T extends Throwable> T extractException(Class<T> type, boolean first, Throwable headOfChain) {
        Throwable ex = null;
        while (headOfChain != null) {
            if (type.isAssignableFrom(headOfChain.getClass())) {
                ex = headOfChain;
                if (first) break;
            }
            headOfChain = headOfChain.getCause();
        }
        return (T)ex;
    }

    public static Throwable extractException(boolean first, Throwable headOfChain, Class<? extends Throwable> ... types) {
        for (Class<? extends Throwable> type : types) {
            Throwable t = ExceptionHelper.extractException(type, first, headOfChain);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static String concatenateMessages(Throwable headOfChain) {
        StringBuilder buf = new StringBuilder();
        if (headOfChain != null) {
            if (headOfChain.getMessage() != null) {
                buf.append(headOfChain.getMessage());
            }
            for (Throwable cause = headOfChain.getCause(); cause != null; cause = cause.getCause()) {
                String subMsg = cause.getMessage();
                if (subMsg == null || buf.indexOf(subMsg) >= 0) continue;
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(subMsg);
            }
        }
        return buf.toString();
    }

    public static String getStackTraceAsString(Throwable cause) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream(bs);){
            cause.printStackTrace(ps);
            ps.flush();
            String string = bs.toString();
            return string;
        }
    }

    private ExceptionHelper() {
    }
}

