/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.tentackle.common.Freezable;
import org.tentackle.common.TentackleRuntimeException;

public class Binary<T>
implements Serializable,
Cloneable,
Freezable {
    private static final long serialVersionUID = 5853122168291704220L;
    private static final int INITIAL_SIZE = 1024;
    private byte[] data;
    private int length;
    private boolean frozen;
    private transient T object;

    public Binary(T object) throws IOException {
        this.setObject(object);
    }

    public Binary(byte[] data) {
        this.setData(data);
    }

    public Binary() {
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    public Binary<T> clone() {
        Binary binary;
        try {
            binary = (Binary)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        if (binary.data != null) {
            binary.data = new byte[this.length];
            System.arraycopy(this.data, 0, binary.data, 0, this.length);
        }
        binary.frozen = false;
        return binary;
    }

    public static Binary<?> createBinary(InputStream stream, int bufSize, boolean frozen) throws IOException {
        if (stream == null) {
            return null;
        }
        try (InputStream s = stream;){
            int count;
            Binary b = new Binary();
            if (bufSize <= 0) {
                bufSize = 1024;
            }
            b.data = new byte[bufSize];
            while ((count = s.read(b.data, b.length, bufSize - b.length)) >= 0) {
                b.length += count;
                if (b.length != bufSize) continue;
                byte[] oldData = b.data;
                b.data = new byte[bufSize <<= 1];
                System.arraycopy(oldData, 0, b.data, 0, b.length);
            }
            if (frozen) {
                b.freeze();
            }
            Binary binary = b.length == 0 ? null : b;
            return binary;
        }
    }

    public int getLength() {
        return this.length;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public T getObject() throws IOException, ClassNotFoundException {
        if (this.object == null && this.data != null) {
            try (ObjectInputStream is = new ObjectInputStream(this.getInputStream());){
                this.object = is.readObject();
            }
        }
        return this.object;
    }

    private void setObject(T object) throws IOException {
        this.object = object;
        if (object == null) {
            this.data = null;
            this.length = 0;
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (ObjectOutputStream os = new ObjectOutputStream(bos);){
                os.writeObject(object);
                os.flush();
                this.data = bos.toByteArray();
                this.length = bos.size();
            }
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.assertNotfrozen();
        this.data = data;
        this.object = null;
        this.length = data == null ? 0 : data.length;
    }

    private void assertNotfrozen() {
        if (this.frozen) {
            throw new TentackleRuntimeException("binary is frozen");
        }
    }
}

