/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.tentackle.common.TentackleRuntimeException;

public final class ExceptionHelper {
    public static <T extends Throwable> T extractException(Class<T> type, boolean first, Throwable headOfChain) {
        Throwable ex = null;
        while (headOfChain != null) {
            if (type.isAssignableFrom(headOfChain.getClass())) {
                ex = headOfChain;
                if (first) break;
            }
            headOfChain = headOfChain.getCause();
        }
        return (T)ex;
    }

    public static Throwable extractException(boolean first, Throwable headOfChain, Class<? extends Throwable> ... types) {
        Throwable ex = null;
        block0: while (headOfChain != null) {
            for (Class<? extends Throwable> type : types) {
                if (!type.isAssignableFrom(headOfChain.getClass())) continue;
                ex = headOfChain;
                if (!first) break;
                break block0;
            }
            headOfChain = headOfChain.getCause();
        }
        return ex;
    }

    public static TentackleRuntimeException extractTemporaryException(boolean first, Throwable ex) {
        TentackleRuntimeException temporaryException = null;
        while (ex != null) {
            TentackleRuntimeException tex;
            if (ex instanceof TentackleRuntimeException && (tex = (TentackleRuntimeException)ex).isTemporary()) {
                temporaryException = tex;
                if (first) break;
            }
            ex = ex.getCause();
        }
        return temporaryException;
    }

    public static String getMessage(Throwable ex) {
        while (ex != null) {
            String message = ex.getMessage();
            if (message != null && !message.isBlank()) {
                return message;
            }
            ex = ex.getCause();
        }
        return null;
    }

    public static boolean handleException(boolean first, Throwable headOfChain, Handler<? extends Throwable> ... handlers) {
        Throwable ex = null;
        Handler<? extends Throwable> found = null;
        block0: while (headOfChain != null) {
            for (Handler<? extends Throwable> handler : handlers) {
                if (!handler.appliesTo(headOfChain)) continue;
                found = handler;
                ex = headOfChain;
                if (!first) break;
                break block0;
            }
            headOfChain = headOfChain.getCause();
        }
        if (found != null) {
            found.handle(ex);
            return true;
        }
        return false;
    }

    public static String concatenateMessages(Throwable headOfChain) {
        StringBuilder buf = new StringBuilder();
        if (headOfChain != null) {
            if (headOfChain.getMessage() != null) {
                buf.append(headOfChain.getMessage());
            }
            for (Throwable cause = headOfChain.getCause(); cause != null; cause = cause.getCause()) {
                String subMsg = cause.getMessage();
                if (subMsg == null || buf.indexOf(subMsg) >= 0) continue;
                if (!buf.isEmpty()) {
                    buf.append('\n');
                }
                buf.append(subMsg);
            }
        }
        return buf.toString();
    }

    public static String getStackTraceAsString(Throwable cause) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream(bs);){
            cause.printStackTrace(ps);
            ps.flush();
            String string = bs.toString();
            return string;
        }
    }

    public static boolean isClassValuableForStackTrace(String className) {
        return !className.startsWith("java") && !className.startsWith("com.sun.") && !className.startsWith("sun.") && !className.startsWith("jdk.") && (!className.startsWith("org.tentackle.") || !className.contains("InvocationHandler") && !className.contains("Interceptable"));
    }

    public static StackTraceElement[] filterStackTrace(StackTraceElement[] trace) {
        ArrayList<StackTraceElement> stackList = new ArrayList<StackTraceElement>();
        if (trace != null && trace.length > 0) {
            boolean valuableFound = false;
            for (StackTraceElement elem : trace) {
                boolean valuable = ExceptionHelper.isClassValuableForStackTrace(elem.getClassName());
                if (valuable || !valuableFound) {
                    stackList.add(elem);
                }
                if (!valuable) continue;
                valuableFound = true;
            }
        }
        trace = new StackTraceElement[stackList.size()];
        stackList.toArray(trace);
        return trace;
    }

    private ExceptionHelper() {
    }

    public static class Handler<T extends Throwable> {
        private final Class<T> type;
        private final Consumer<T> consumer;

        public Handler(Class<T> type, Consumer<T> consumer) {
            this.type = type;
            this.consumer = consumer;
        }

        public boolean appliesTo(Throwable t) {
            return this.type.isAssignableFrom(t.getClass());
        }

        public void handle(T t) {
            this.consumer.accept(t);
        }
    }
}

