/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import org.tentackle.common.DateHelper;
import org.tentackle.common.Freezable;
import org.tentackle.common.TentackleRuntimeException;

public class Date
extends java.sql.Date
implements Freezable {
    private static final long serialVersionUID = 1L;
    private boolean frozen;

    public static Date createFrozen(long epoch) {
        Date date = new Date(epoch);
        date.freeze();
        return date;
    }

    public static Date valueOf(String str) {
        return new Date(java.sql.Date.valueOf(str).getTime());
    }

    public Date(long date) {
        super(date);
    }

    public Date() {
        this(System.currentTimeMillis());
    }

    @Override
    public Date clone() {
        Date date = (Date)super.clone();
        date.frozen = false;
        return date;
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    @Override
    public void setTime(long date) {
        this.assertNotFrozen();
        super.setTime(date);
    }

    @Override
    @Deprecated
    public void setYear(int year) {
        this.assertNotFrozen();
        super.setYear(year);
    }

    @Override
    @Deprecated
    public void setMonth(int month) {
        this.assertNotFrozen();
        super.setMonth(month);
    }

    @Override
    @Deprecated
    public void setDate(int date) {
        this.assertNotFrozen();
        super.setDate(date);
    }

    @Override
    @Deprecated
    public void setHours(int hours) {
        this.assertNotFrozen();
        super.setHours(hours);
    }

    @Override
    @Deprecated
    public void setMinutes(int minutes) {
        this.assertNotFrozen();
        super.setMinutes(minutes);
    }

    @Override
    @Deprecated
    public void setSeconds(int seconds) {
        this.assertNotFrozen();
        super.setSeconds(seconds);
    }

    private void assertNotFrozen() {
        if (this.frozen) {
            throw new TentackleRuntimeException("date is frozen");
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Calendar calendar = DateHelper.toCalendar(this);
        s.writeShort(calendar.get(1));
        s.writeByte(calendar.get(2));
        s.writeByte(calendar.get(5));
        s.writeBoolean(this.frozen);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        short year = s.readShort();
        byte month = s.readByte();
        byte day = s.readByte();
        Calendar cal = DateHelper.today();
        cal.set(year, month, day, 0, 0, 0);
        cal.set(14, 0);
        super.setTime(cal.getTimeInMillis());
        this.frozen = s.readBoolean();
    }
}

