/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tentackle.common.ModuleSorter;
import org.tentackle.common.Service;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.ServiceFinder;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;

@Service(value=ServiceFinder.class)
public class DefaultServiceFinder
implements ServiceFinder {
    private final ClassLoader loader;
    private final String servicePath;
    private final Map<String, Map<String, URL>> serviceMap;
    private final Map<String, Collection<Class<?>>> classMap;

    public DefaultServiceFinder(ClassLoader loader, String servicePath) {
        ClassLoader classLoader = this.loader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
        if (this.loader == null) {
            throw new TentackleRuntimeException("cannot determine classloader");
        }
        if (servicePath == null) {
            this.servicePath = "META-INF/services/";
        } else {
            while (((String)servicePath).startsWith("/")) {
                servicePath = ((String)servicePath).substring(1);
            }
            if (!((String)servicePath).endsWith("/")) {
                servicePath = (String)servicePath + "/";
            }
            this.servicePath = servicePath;
        }
        this.serviceMap = new HashMap<String, Map<String, URL>>();
        this.classMap = new HashMap();
    }

    public DefaultServiceFinder(String servicePath) {
        this(Thread.currentThread().getContextClassLoader(), servicePath);
    }

    public DefaultServiceFinder() {
        this(null);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public String getServicePath() {
        return this.servicePath;
    }

    @Override
    public Collection<URL> findServiceURLs(String serviceName) {
        try {
            Enumeration<URL> resources = this.getClassLoader(serviceName).getResources(this.servicePath + serviceName);
            return ModuleSorter.INSTANCE.sort(resources, serviceName);
        }
        catch (IOException iox) {
            throw new TentackleRuntimeException("loading service information failed", iox);
        }
    }

    @Override
    public synchronized Map<String, URL> findServiceConfigurations(String serviceName) {
        return this.serviceMap.computeIfAbsent(serviceName, sn -> {
            LinkedHashMap<String, URL> services = new LinkedHashMap<String, URL>();
            this.parseURLs(this.findServiceURLs((String)sn), (String)sn, (Map<String, URL>)services);
            return services;
        });
    }

    @Override
    public synchronized Map.Entry<String, URL> findFirstServiceConfiguration(String serviceName) {
        Map<String, URL> services = this.findServiceConfigurations(serviceName);
        if (services.isEmpty()) {
            throw new TentackleRuntimeException("service '" + serviceName + "' not found");
        }
        return services.entrySet().iterator().next();
    }

    @Override
    public synchronized Map.Entry<String, URL> findUniqueServiceConfiguration(String serviceName) {
        Map<String, URL> services = this.findServiceConfigurations(serviceName);
        if (services.isEmpty()) {
            throw new TentackleRuntimeException("service '" + serviceName + "' not found");
        }
        if (services.size() > 1) {
            StringBuilder msg = new StringBuilder();
            msg.append("service '").append(serviceName).append("' defined more than once: ");
            boolean needComma = false;
            for (Map.Entry<String, URL> entry : services.entrySet()) {
                if (needComma) {
                    msg.append(", ");
                }
                msg.append(entry.getKey()).append(" in ").append(entry.getValue());
                needComma = true;
            }
            throw new TentackleRuntimeException(msg.toString());
        }
        return services.entrySet().iterator().next();
    }

    @Override
    public synchronized <T> Collection<Class<T>> findServiceProviders(Class<T> service) throws ClassNotFoundException {
        String serviceName = service.getName();
        Collection<Class<T>> serviceImplClasses = this.classMap.get(serviceName);
        if (serviceImplClasses == null) {
            serviceImplClasses = new ArrayList<Class<T>>();
            for (Map.Entry<String, URL> entry : this.findServiceConfigurations(serviceName).entrySet()) {
                String serviceImplName = entry.getKey();
                Class<?> provider = Class.forName(serviceImplName, true, this.getClassLoader(serviceName));
                this.checkProvider(provider, service, entry.getValue());
                serviceImplClasses.add(provider);
            }
            this.classMap.put(serviceName, serviceImplClasses);
        }
        return serviceImplClasses;
    }

    @Override
    public <T> Class<T> findFirstServiceProvider(Class<T> service) throws ClassNotFoundException {
        String serviceName = service.getName();
        Map.Entry<String, URL> entry = this.findFirstServiceConfiguration(serviceName);
        Class<?> provider = Class.forName(entry.getKey(), true, this.getClassLoader(serviceName));
        this.checkProvider(provider, service, entry.getValue());
        return provider;
    }

    @Override
    public <T> Class<T> findUniqueServiceProvider(Class<T> service) throws ClassNotFoundException {
        String serviceName = service.getName();
        Map.Entry<String, URL> entry = this.findUniqueServiceConfiguration(serviceName);
        Class<?> provider = Class.forName(entry.getKey(), true, this.getClassLoader(serviceName));
        this.checkProvider(provider, service, entry.getValue());
        return provider;
    }

    @Override
    public synchronized Map<String, String> createNameMap(String serviceName) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (Map.Entry<String, URL> entry : ServiceFactory.getServiceFinder("META-INF/mapped-services/").findServiceConfigurations(serviceName).entrySet()) {
            String configuration = entry.getKey();
            int ndx = StringHelper.indexAnyOf(configuration, ":=");
            if (ndx < 0) {
                throw new TentackleRuntimeException("invalid service configuration '" + configuration + "' in " + String.valueOf(entry.getValue()));
            }
            String key = StringHelper.parseString(configuration.substring(ndx + 1).trim());
            String value = configuration.substring(0, ndx).trim();
            nameMap.putIfAbsent(key, value);
        }
        return nameMap;
    }

    @Override
    public synchronized Map<String, Set<String>> createNameMapToAll(String serviceName) {
        HashMap<String, Set<String>> nameMap = new HashMap<String, Set<String>>();
        for (Map.Entry<String, URL> entry : ServiceFactory.getServiceFinder("META-INF/mapped-services/").findServiceConfigurations(serviceName).entrySet()) {
            String configuration = entry.getKey();
            List<String> parts = StringHelper.split(configuration, ":= ");
            if (parts.size() != 2) {
                throw new TentackleRuntimeException("invalid service configuration '" + configuration + "' in " + String.valueOf(entry.getValue()));
            }
            String key = parts.get(1);
            Set serviceList = nameMap.computeIfAbsent(key, k -> new HashSet());
            serviceList.add(parts.get(0));
        }
        return nameMap;
    }

    protected ClassLoader getClassLoader(String serviceName) {
        ClassLoader cl = ServiceFactory.getExplicitClassLoader(this.servicePath, serviceName);
        if (cl == null) {
            cl = this.getClassLoader();
        }
        return cl;
    }

    protected void parseURL(URL url, String serviceName, Map<String, URL> services) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                URL otherUrl;
                if ((line = this.normalizeLine(line)) == null || (otherUrl = services.put(line, url)) == null) continue;
                String urlText = url.toString();
                String otherUrlText = otherUrl.toString();
                int urlNdx = urlText.lastIndexOf(this.servicePath);
                int otherUrlNdx = otherUrlText.lastIndexOf(this.servicePath);
                if (urlNdx > 0 && otherUrlNdx > 0 && urlText.endsWith(otherUrlText.substring(otherUrlNdx))) continue;
                throw new TentackleRuntimeException("service " + serviceName + " defined more than once! (" + String.valueOf(otherUrl) + " and " + String.valueOf(url) + ")");
            }
        }
        catch (IOException iox) {
            throw new TentackleRuntimeException("error reading configuration from " + String.valueOf(url), iox);
        }
    }

    protected void parseURLs(Collection<URL> urls, String serviceName, Map<String, URL> services) {
        urls.forEach(url -> this.parseURL((URL)url, serviceName, services));
    }

    protected String normalizeLine(String line) {
        boolean quoteFound = false;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (quoteFound) {
                if (c != '#') {
                    buf.append('\\');
                }
                buf.append(c);
                quoteFound = false;
                continue;
            }
            if (c == '\\') {
                quoteFound = true;
                continue;
            }
            if (c == '#') break;
            buf.append(c);
        }
        return (line = buf.toString().trim()).isEmpty() ? null : line;
    }

    private void checkProvider(Class<?> provider, Class<?> service, URL url) {
        if (!service.isAssignableFrom(provider)) {
            throw new TentackleRuntimeException("provider '" + String.valueOf(provider) + "' does not implement '" + String.valueOf(service) + "', configured in " + String.valueOf(url));
        }
    }
}

