/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.util.Locale;
import org.tentackle.common.Service;
import org.tentackle.common.StringNormalizer;

@Service(value=StringNormalizer.class)
public class DefaultStringNormalizer
implements StringNormalizer {
    private static final char[] CRITS = "\u00c4\u00c0\u00c1\u00c2\u00c3\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d6\u00d2\u00d3\u00d4\u00d5\u00d7\u00d8\u00dc\u00d9\u00da\u00db\u00dd\u00de\u00e4\u00e0\u00e1\u00e2\u00e3\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f6\u00f0\u00f2\u00f3\u00f4\u00f5\u00f8\u00fc\u00f9\u00fa\u00fb\u00fd\u00fe\u00ff\u00df".toCharArray();
    private static final char[] NORMS = "AAAAAAACEEEEIIIIDNOOOOOXOUUUUYBaaaaaaaceeeeiiiinooooooouuuuybys".toCharArray();
    private final char wordSeparator;
    private final char fieldSeparator;

    public DefaultStringNormalizer(char fieldSeparator, char wordSeparator) {
        this.fieldSeparator = fieldSeparator;
        this.wordSeparator = wordSeparator;
    }

    public DefaultStringNormalizer() {
        this(',', ' ');
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String unDiacrit(String str, boolean keepLength) {
        block12: {
            if (str == null) break block12;
            buf = new StringBuilder();
            len = str.length();
            block9: for (i = 0; i < len; ++i) {
                c = str.charAt(i);
                if (keepLength) ** GOTO lbl-1000
                switch (c) {
                    case '\u00c4': 
                    case '\u00c6': {
                        buf.append(i < len - 1 && Character.isUpperCase(str.charAt(i + 1)) != false ? "AE" : "Ae");
                        continue block9;
                    }
                    case '\u00dc': {
                        buf.append(i < len - 1 && Character.isUpperCase(str.charAt(i + 1)) != false ? "UE" : "Ue");
                        continue block9;
                    }
                    case '\u00d6': {
                        buf.append(i < len - 1 && Character.isUpperCase(str.charAt(i + 1)) != false ? "OE" : "Oe");
                        continue block9;
                    }
                    case '\u00e4': 
                    case '\u00e6': {
                        buf.append("ae");
                        continue block9;
                    }
                    case '\u00fc': {
                        buf.append("ue");
                        continue block9;
                    }
                    case '\u00f6': {
                        buf.append("oe");
                        continue block9;
                    }
                    case '\u00df': {
                        buf.append("ss");
                        continue block9;
                    }
                    default: lbl-1000:
                    // 3 sources

                    {
                        for (m = 0; m < DefaultStringNormalizer.CRITS.length; ++m) {
                            if (DefaultStringNormalizer.CRITS[m] != c) continue;
                            c = DefaultStringNormalizer.NORMS[m];
                            break;
                        }
                        if (c >= ' ' && c <= '\u007f') {
                            buf.append(c);
                            continue block9;
                        }
                        if (!keepLength) continue block9;
                        buf.append('?');
                    }
                }
            }
            return buf.toString();
        }
        return null;
    }

    @Override
    public String normalize(String str) {
        if ((str = this.unDiacrit(str, false)) != null) {
            char c;
            int i;
            str = str.toUpperCase(Locale.ENGLISH);
            int len = str.length();
            StringBuilder sb = new StringBuilder(len);
            boolean lastCharWasSpace = false;
            boolean lastCharWasFieldSeparator = false;
            for (i = 0; i < len; ++i) {
                c = str.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    lastCharWasSpace = false;
                    lastCharWasFieldSeparator = false;
                } else if (c == this.fieldSeparator && c != '\u0000') {
                    if (lastCharWasFieldSeparator) continue;
                    lastCharWasFieldSeparator = true;
                    lastCharWasSpace = false;
                } else {
                    if (lastCharWasSpace) continue;
                    lastCharWasSpace = true;
                    lastCharWasFieldSeparator = false;
                    c = this.wordSeparator;
                }
                if (i + 2 < len && c == 'S' && str.charAt(i + 1) == 'C' && str.charAt(i + 2) == 'H') {
                    i += 2;
                }
                if (i + 1 < len) {
                    if (c == 'C' && str.charAt(i + 1) == 'H') {
                        c = 'K';
                        ++i;
                    } else if (c == 'C' && str.charAt(i + 1) == 'K') {
                        c = 'K';
                        ++i;
                    } else if (c == 'P' && str.charAt(i + 1) == 'H') {
                        c = 'F';
                        ++i;
                    } else if (c == 'T' && str.charAt(i + 1) == 'H') {
                        c = 'T';
                        ++i;
                    }
                }
                switch (c) {
                    case 'D': {
                        c = 'T';
                        break;
                    }
                    case 'C': 
                    case 'G': 
                    case 'Q': {
                        c = 'K';
                        break;
                    }
                    case 'Y': {
                        c = 'I';
                        break;
                    }
                    case 'B': {
                        c = 'P';
                        break;
                    }
                    case 'W': {
                        c = 'V';
                        break;
                    }
                    case 'Z': {
                        c = 'S';
                        break;
                    }
                }
                sb.append(c);
            }
            len = sb.length();
            for (i = 0; i < len; ++i) {
                int c3;
                c = sb.charAt(i);
                if (i + 1 < len) {
                    if (c == 'A' && sb.charAt(i + 1) == 'I') {
                        sb.setCharAt(i, 'E');
                    }
                    if (Character.isLetter(c) && c == sb.charAt(i + 1)) {
                        sb.deleteCharAt(i + 1);
                        --len;
                        continue;
                    }
                    if (c == 'I' && sb.charAt(i + 1) == 'E') {
                        sb.deleteCharAt(i + 1);
                        --len;
                        continue;
                    }
                }
                if (i + 1 >= len) continue;
                char c2 = sb.charAt(i + 1);
                int n = c3 = i + 2 < len ? (int)sb.charAt(i + 2) : 32;
                if (c != 'A' && c != 'E' && c != 'I' && c != 'O' && c != 85 || c2 != 'H' || c3 == 65 && c3 == 69 && c3 == 73 && c3 == 79 && c3 == 85) continue;
                sb.deleteCharAt(i + 1);
                --len;
            }
            len = sb.length();
            if (len > 0) {
                StringBuilder fb = new StringBuilder(len);
                for (int i2 = 0; i2 < len; ++i2) {
                    char c2 = sb.charAt(i2);
                    if (c2 == this.wordSeparator) continue;
                    fb.append(c2);
                }
                return fb.toString();
            }
            return "";
        }
        return null;
    }
}

