/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.tentackle.common.Cryptor;
import org.tentackle.common.TentackleRuntimeException;

public class EncryptedProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private String name;
    private String keyPrefix;
    private transient Map<String, String> keyCaseMap;

    public EncryptedProperties() {
    }

    public EncryptedProperties(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public EncryptedProperties clone() {
        return (EncryptedProperties)super.clone();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    @Override
    public String getProperty(String key) {
        return this.getValue(key).getText();
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        if (this.keyCaseMap != null) {
            this.keyCaseMap.put(key.toUpperCase(Locale.ROOT), key);
        }
        return super.setProperty(this.translateKey(key), value);
    }

    public String getPropertyIgnoreCase(String key) {
        String csKey = this.getKeyIgnoreCase(key);
        return csKey == null ? null : this.getProperty(csKey);
    }

    public String getKeyIgnoreCase(String key) {
        String csKey = this.getKeyCaseMap().get(key.toUpperCase(Locale.ROOT));
        return csKey == null ? key : csKey;
    }

    @Override
    public Set<String> stringPropertyNames() {
        Set<String> keys = super.stringPropertyNames();
        if (this.keyPrefix != null) {
            HashSet<String> prefixKeys = new HashSet<String>();
            for (String key : keys) {
                if (!key.startsWith(this.keyPrefix)) continue;
                prefixKeys.add(key.substring(this.keyPrefix.length()));
            }
            keys = Collections.unmodifiableSet(prefixKeys);
        }
        return keys;
    }

    public String getPropertyBlunt(String key) {
        return super.getProperty(this.translateKey(key));
    }

    public char[] getPropertyAsChars(String key) {
        return this.getValue(key).getChars();
    }

    public char[] getPropertyAsChars(String key, char[] defaults) {
        char[] chars = this.getPropertyAsChars(key);
        return chars == null ? defaults : chars;
    }

    public void setEncryptedProperty(String key, String value) {
        Cryptor cryptor = Cryptor.getInstance();
        if (cryptor != null) {
            this.setProperty(key, "~" + cryptor.encrypt64(Objects.requireNonNull(value, "missing value (String)")));
        } else {
            this.setProperty(key, value);
        }
    }

    public void setEncryptedProperty(String key, char[] value) {
        key = this.translateKey(key);
        Cryptor cryptor = Cryptor.getInstance();
        if (cryptor != null) {
            this.setProperty(key, "~" + Cryptor.getInstance().encrypt64(value));
        } else {
            super.setProperty(key, String.valueOf(value));
        }
    }

    private Map<String, String> getKeyCaseMap() {
        if (this.keyCaseMap == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String name : this.stringPropertyNames()) {
                if (map.put(name.toUpperCase(Locale.ROOT), name) == null) continue;
                throw new TentackleRuntimeException("duplicate case-insensitive key '" + name + "' found");
            }
            this.keyCaseMap = map;
        }
        return this.keyCaseMap;
    }

    private Value getValue(String key) {
        String text = super.getProperty(this.translateKey(key));
        boolean encrypted = false;
        if (text != null) {
            if (text.startsWith("~")) {
                text = text.substring(1);
                encrypted = true;
            } else if (text.startsWith("\\~")) {
                text = text.substring(1);
            }
        }
        return new Value(text, encrypted);
    }

    private String translateKey(String key) {
        return this.keyPrefix == null ? key : this.keyPrefix + key;
    }

    private record Value(String text, boolean encrypted) {
        private String getText() {
            return this.encrypted ? Cryptor.getInstanceSafely().decrypt64(this.text) : this.text;
        }

        private char[] getChars() {
            return this.encrypted ? Cryptor.getInstanceSafely().decrypt64ToChars(this.text) : (char[])(this.text == null ? null : this.text.toCharArray());
        }
    }
}

