/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import org.tentackle.common.NamingRulesHolder;
import org.tentackle.common.Service;

@Service(value=NamingRules.class)
public class NamingRules {
    private static final String DOMAIN_SUFFIX = "Domain";
    private static final String DOMAIN_IMPL_SUFFIX = "DomainImpl";
    private static final String PERSISTENCE_SUFFIX = "Persistence";
    private static final String PERSISTENCE_IMPL_SUFFIX = "PersistenceImpl";
    private static final String REMOTE_SUFFIX = "RemoteDelegate";
    private static final String REMOTE_IMPL_SUFFIX = "RemoteDelegateImpl";
    private static final String REMOTE_SUB_PACKAGE = ".rmi";

    public static NamingRules getInstance() {
        return NamingRulesHolder.INSTANCE;
    }

    public String getPdoDomainInterface(String pdoName) {
        return pdoName + DOMAIN_SUFFIX;
    }

    public String getPdoFromDomainInterface(String domainInterface) {
        if (domainInterface.endsWith(DOMAIN_SUFFIX)) {
            return domainInterface.substring(0, domainInterface.length() - DOMAIN_SUFFIX.length());
        }
        return null;
    }

    public String getPdoPersistenceInterface(String pdoName) {
        return pdoName + PERSISTENCE_SUFFIX;
    }

    public String getPdoFromPersistenceInterface(String persistenceInterface) {
        if (persistenceInterface.endsWith(PERSISTENCE_SUFFIX)) {
            return persistenceInterface.substring(0, persistenceInterface.length() - PERSISTENCE_SUFFIX.length());
        }
        return null;
    }

    public String getPdoDomainImplementation(String pdoName) {
        return pdoName + DOMAIN_IMPL_SUFFIX;
    }

    public String getPdoFromDomainImplementation(String domainImplementation) {
        if (domainImplementation.endsWith(DOMAIN_IMPL_SUFFIX)) {
            return domainImplementation.substring(0, domainImplementation.length() - DOMAIN_IMPL_SUFFIX.length());
        }
        return null;
    }

    public String getPdoPersistenceImplementation(String pdoName) {
        return pdoName + PERSISTENCE_IMPL_SUFFIX;
    }

    public String getPdoFromPersistenceImplementation(String persistenceImplementation) {
        if (persistenceImplementation.endsWith(PERSISTENCE_IMPL_SUFFIX)) {
            return persistenceImplementation.substring(0, persistenceImplementation.length() - PERSISTENCE_IMPL_SUFFIX.length());
        }
        return null;
    }

    public String getPdoRemoteInterface(String pdoName) {
        return pdoName + REMOTE_SUFFIX;
    }

    public String getPdoFromRemoteInterface(String remoteInterface) {
        if (remoteInterface.endsWith(REMOTE_SUFFIX)) {
            return remoteInterface.substring(0, remoteInterface.length() - REMOTE_SUFFIX.length());
        }
        return null;
    }

    public String getPdoRemoteImplementation(String pdoName) {
        return pdoName + REMOTE_IMPL_SUFFIX;
    }

    public String getPdoFromRemoteImplementation(String remoteImplementation) {
        if (remoteImplementation.endsWith(REMOTE_IMPL_SUFFIX)) {
            return remoteImplementation.substring(0, remoteImplementation.length() - REMOTE_IMPL_SUFFIX.length());
        }
        return null;
    }

    public String getPdoRemoteInterfacePackageName(String pdoPersistenceImplementationPackageName) {
        return pdoPersistenceImplementationPackageName + REMOTE_SUB_PACKAGE;
    }

    public String getPdoRemoteImplementationPackageName(String pdoPersistenceImplementationPackageName) {
        return this.getPdoRemoteInterfacePackageName(pdoPersistenceImplementationPackageName);
    }

    public String getOperationDomainInterface(String operationName) {
        return this.getPdoDomainInterface(operationName);
    }

    public String getOperationFromDomainInterface(String domainInterface) {
        return this.getPdoFromDomainInterface(domainInterface);
    }

    public String getOperationPersistenceInterface(String operationName) {
        return this.getPdoPersistenceInterface(operationName);
    }

    public String getOperationFromPersistenceInterface(String persistenceInterface) {
        return this.getPdoFromPersistenceInterface(persistenceInterface);
    }

    public String getOperationDomainImplementation(String operationName) {
        return this.getPdoDomainImplementation(operationName);
    }

    public String getOperationFromDomainImplementation(String domainImplementation) {
        return this.getPdoFromDomainImplementation(domainImplementation);
    }

    public String getOperationPersistenceImplementation(String operationName) {
        return this.getPdoPersistenceImplementation(operationName);
    }

    public String getOperationFromPersistenceImplementation(String persistenceImplementation) {
        return this.getPdoFromPersistenceImplementation(persistenceImplementation);
    }

    public String getOperationRemoteInterface(String operationName) {
        return this.getPdoRemoteInterface(operationName);
    }

    public String getOperationFromRemoteInterface(String remoteInterface) {
        return this.getPdoFromRemoteInterface(remoteInterface);
    }

    public String getOperationRemoteImplementation(String operationName) {
        return this.getPdoRemoteImplementation(operationName);
    }

    public String getOperationFromRemoteImplementation(String remoteImplementation) {
        return this.getPdoFromRemoteImplementation(remoteImplementation);
    }

    public String getOperationRemoteInterfacePackageName(String operationPersistenceImplementationPackageName) {
        return this.getPdoRemoteInterfacePackageName(operationPersistenceImplementationPackageName);
    }

    public String getOperationRemoteImplementationPackageName(String operationPersistenceImplementationPackageName) {
        return this.getOperationRemoteInterfacePackageName(operationPersistenceImplementationPackageName);
    }
}

