/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.Serializable;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class ParameterString
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();

    public ParameterString() {
    }

    public ParameterString(String parameterString) throws ParseException {
        this();
        this.parse(parameterString);
    }

    public String setParameter(String name, String value) {
        if (value == null) {
            return this.parameters.remove(name);
        }
        return this.parameters.put(name, value);
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public String[] getParameterNames() {
        return this.parameters.keySet().toArray(new String[0]);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            if (!buf.isEmpty()) {
                buf.append(", ");
            }
            buf.append(entry.getKey());
            if ("".equals(entry.getValue())) continue;
            buf.append("='");
            buf.append(this.encodeValue(entry.getValue()));
            buf.append("'");
        }
        return buf.toString();
    }

    public Properties toProperties() {
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        return props;
    }

    public void parse(String parameterString) throws ParseException {
        this.parameters.clear();
        if (parameterString != null) {
            StringBuilder nameBuf = null;
            StringBuilder valueBuf = null;
            int valueStart = 0;
            int len = parameterString.length();
            for (int pos = 0; pos < len; ++pos) {
                char c = parameterString.charAt(pos);
                if (nameBuf == null) {
                    if (!Character.isJavaIdentifierStart(c)) continue;
                    nameBuf = new StringBuilder();
                    nameBuf.append(c);
                    continue;
                }
                if (valueBuf == null) {
                    if (Character.isJavaIdentifierPart(c)) {
                        nameBuf.append(c);
                        continue;
                    }
                    if (c == '\'') {
                        valueBuf = new StringBuilder();
                        valueStart = pos;
                        continue;
                    }
                    if (!Character.isWhitespace(c)) continue;
                    this.parameters.put(nameBuf.toString(), "");
                    nameBuf = null;
                    continue;
                }
                if (c == '\'') {
                    if (pos < len - 1 && parameterString.charAt(pos + 1) == '\'') {
                        ++pos;
                        valueBuf.append(c);
                        continue;
                    }
                    this.parameters.put(nameBuf.toString(), valueBuf.toString());
                    nameBuf = null;
                    valueBuf = null;
                    continue;
                }
                valueBuf.append(c);
            }
            if (valueBuf != null) {
                throw new ParseException("malformed parameter string at value " + String.valueOf(nameBuf) + "=" + String.valueOf(valueBuf), valueStart);
            }
            if (nameBuf != null) {
                this.parameters.put(nameBuf.toString(), "");
            }
        }
    }

    private String encodeValue(String value) {
        return value.replace("'", "''");
    }
}

