/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tentackle.common.ModuleInfo;
import org.tentackle.common.ModuleSorter;
import org.tentackle.common.ServiceFactory;
import org.tentackle.common.StringHelper;
import org.tentackle.common.TentackleRuntimeException;

public class BundleSupport {
    public static final String BUNDLE_SERVICE = BundleSupport.class.getName();
    private final ModuleInfo info;
    private final String className;
    private final String bundleName;

    public static List<BundleSupport> getBundles(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = BundleSupport.class.getClassLoader();
        }
        ArrayList<BundleSupport> bundles = new ArrayList<BundleSupport>();
        for (Map.Entry<String, URL> providerEntry : ServiceFactory.getServiceFinder(classLoader, "META-INF/services/").findServiceConfigurations(BUNDLE_SERVICE).entrySet()) {
            String serviceName = providerEntry.getKey();
            for (Map.Entry<String, URL> entry : ServiceFactory.getServiceFinder(classLoader, "META-INF/bundles/").findServiceConfigurations(serviceName).entrySet()) {
                ModuleInfo info = ModuleSorter.INSTANCE.getModuleInfo(entry.getValue());
                List<String> parts = StringHelper.split(entry.getKey(), ":= ");
                String className = parts.get(0);
                String bundleName = switch (parts.size()) {
                    case 1 -> className;
                    case 2 -> parts.get(1);
                    default -> throw new TentackleRuntimeException("invalid bundle configuration '" + entry.getKey() + "' in " + String.valueOf(entry.getValue()));
                };
                bundles.add(new BundleSupport(info, className, bundleName));
            }
        }
        return bundles;
    }

    public BundleSupport(ModuleInfo info, String className, String bundleName) {
        this.info = info;
        this.className = className;
        this.bundleName = bundleName;
    }

    public ModuleInfo getModuleInfo() {
        return this.info;
    }

    public String getClassName() {
        return this.className;
    }

    public String getBundleName() {
        return this.bundleName;
    }
}

