/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.tentackle.common.LocaleProviderHolder;
import org.tentackle.common.Service;
import org.tentackle.common.TentackleRuntimeException;

@Service(value=LocaleProvider.class)
public class LocaleProvider {
    private final ThreadLocal<Locale> tlLocale = new ThreadLocal();
    private final List<Locale> EFFECTIVE_LOCALES = List.of(Locale.ENGLISH);
    private final Locale initialLocale = Locale.getDefault();
    private Locale effectiveInitialLocale;

    public static LocaleProvider getInstance() {
        return LocaleProviderHolder.INSTANCE;
    }

    public Locale getInitialLocale() {
        return this.initialLocale;
    }

    public Locale getEffectiveInitialLocale() {
        if (this.effectiveInitialLocale == null) {
            this.effectiveInitialLocale = this.getEffectiveLocale(this.initialLocale);
        }
        return this.effectiveInitialLocale;
    }

    public Locale getCurrentLocale() {
        return this.tlLocale.get();
    }

    public Locale getLocale() {
        Locale locale = this.getCurrentLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public void setCurrentLocale(Locale locale) {
        this.tlLocale.set(locale);
    }

    public void assertCurrentLocaleValid() {
        if (this.getCurrentLocale() == null) {
            throw new TentackleRuntimeException("no thread-local Locale");
        }
    }

    public Locale getEffectiveLocale(Locale locale) {
        return locale;
    }

    public Locale getEffectiveLocale() {
        return this.getEffectiveLocale(this.getLocale());
    }

    public Locale getFallbackLocale() {
        return Locale.ENGLISH;
    }

    public List<Locale> getEffectiveLocales() {
        return this.EFFECTIVE_LOCALES;
    }

    public boolean isLocaleSupported(Locale locale) {
        for (Locale effectiveLocale : this.getEffectiveLocales()) {
            if (!effectiveLocale.equals(locale)) continue;
            return true;
        }
        return false;
    }

    public String toTag(Locale locale) {
        StringBuilder buf = new StringBuilder();
        buf.append(locale.getLanguage());
        String str = locale.getCountry();
        if (!str.isEmpty()) {
            buf.append('_').append(str);
            str = locale.getVariant();
            if (!str.isEmpty()) {
                buf.append('_').append(str);
            }
        }
        return buf.toString();
    }

    public Locale fromTag(String tag) {
        Locale locale = null;
        String language = null;
        String country = null;
        String variant = null;
        if (tag != null) {
            StringTokenizer stok = new StringTokenizer(tag, "_");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken();
                if (language == null) {
                    language = token;
                    continue;
                }
                if (country == null) {
                    country = token;
                    continue;
                }
                if (variant != null) continue;
                variant = token;
            }
            if (variant != null) {
                locale = Locale.of(language, country, variant);
            } else if (country != null) {
                locale = Locale.of(language, country);
            } else if (language != null) {
                locale = Locale.of(language);
            }
        }
        return locale;
    }
}

