/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import org.tentackle.common.Freezable;
import org.tentackle.common.TentackleRuntimeException;

public class Date
extends java.sql.Date
implements Freezable {
    private static final long serialVersionUID = 1511598038487230101L;
    private boolean frozen;
    private transient Calendar cal;

    public static Date createFrozen(long epoch) {
        Date date = new Date(epoch);
        date.freeze();
        return date;
    }

    public Date(long date) {
        super(date);
    }

    public Date() {
        this(System.currentTimeMillis());
    }

    @Override
    public Date clone() {
        Date date = (Date)super.clone();
        date.frozen = false;
        return date;
    }

    public Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = Calendar.getInstance();
            this.cal.setTime(this);
        }
        return this.cal;
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    @Override
    public void setTime(long date) {
        this.assertNotfrozen();
        super.setTime(date);
        this.cal = null;
    }

    @Override
    public void setYear(int year) {
        this.assertNotfrozen();
        super.setYear(year);
    }

    @Override
    public void setMonth(int month) {
        this.assertNotfrozen();
        super.setMonth(month);
    }

    @Override
    public void setDate(int date) {
        this.assertNotfrozen();
        super.setDate(date);
    }

    @Override
    public void setHours(int hours) {
        this.assertNotfrozen();
        super.setHours(hours);
    }

    @Override
    public void setMinutes(int minutes) {
        this.assertNotfrozen();
        super.setMinutes(minutes);
    }

    @Override
    public void setSeconds(int seconds) {
        this.assertNotfrozen();
        super.setSeconds(seconds);
    }

    private void assertNotfrozen() {
        if (this.frozen) {
            throw new TentackleRuntimeException("date is frozen");
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeShort(this.getCalendar().get(1));
        s.writeByte(this.getCalendar().get(2));
        s.writeByte(this.getCalendar().get(5));
        s.writeBoolean(this.frozen);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        short year = s.readShort();
        byte month = s.readByte();
        byte day = s.readByte();
        this.cal = Calendar.getInstance();
        this.cal.set(year, month, day, 0, 0, 0);
        this.cal.set(14, 0);
        super.setTime(this.cal.getTimeInMillis());
        this.frozen = s.readBoolean();
    }
}

