/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FileHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String name, boolean asResource) throws IOException {
        Properties dbProps = new Properties();
        if (name != null) {
            if (name.indexOf(46) < 0) {
                name = name + ".properties";
            }
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            InputStream is = null;
            try {
                if (asResource) {
                    is = FileHelper.class.getResourceAsStream(name);
                    if (is == null && (is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name)) == null) {
                        throw new FileNotFoundException("no such resource");
                    }
                } else {
                    is = new FileInputStream(name);
                }
                is = new BufferedInputStream(is);
                dbProps.load(is);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return dbProps;
    }

    public static Properties loadProperties(String name) throws IOException {
        try {
            return FileHelper.loadProperties(name, false);
        }
        catch (FileNotFoundException e1) {
            return FileHelper.loadProperties(name, true);
        }
    }

    private FileHelper() {
    }
}

