/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import org.tentackle.common.Freezable;
import org.tentackle.common.TentackleRuntimeException;

public class Time
extends java.sql.Time
implements Freezable {
    private static final long serialVersionUID = 8397324403548013688L;
    private boolean frozen;
    private transient Calendar cal;

    public static Time createFrozen(long epoch) {
        Time time = new Time(epoch);
        time.freeze();
        return time;
    }

    public Time(long time) {
        super(time);
    }

    public Time() {
        this(System.currentTimeMillis());
    }

    @Override
    public Time clone() {
        Time time = (Time)super.clone();
        time.frozen = false;
        return time;
    }

    public Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = Calendar.getInstance();
            this.cal.setTime(this);
        }
        return this.cal;
    }

    @Override
    public void freeze() {
        this.frozen = true;
    }

    @Override
    public void setTime(long time) {
        this.assertNotfrozen();
        super.setTime(time);
        this.cal = null;
    }

    @Override
    public void setYear(int year) {
        this.assertNotfrozen();
        super.setYear(year);
    }

    @Override
    public void setMonth(int month) {
        this.assertNotfrozen();
        super.setMonth(month);
    }

    @Override
    public void setDate(int date) {
        this.assertNotfrozen();
        super.setDate(date);
    }

    @Override
    public void setHours(int hours) {
        this.assertNotfrozen();
        super.setHours(hours);
    }

    @Override
    public void setMinutes(int minutes) {
        this.assertNotfrozen();
        super.setMinutes(minutes);
    }

    @Override
    public void setSeconds(int seconds) {
        this.assertNotfrozen();
        super.setSeconds(seconds);
    }

    private void assertNotfrozen() {
        if (this.frozen) {
            throw new TentackleRuntimeException("time is frozen");
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeByte(this.getCalendar().get(11));
        s.writeByte(this.getCalendar().get(12));
        s.writeByte(this.getCalendar().get(13));
        s.writeShort(this.getCalendar().get(14));
        s.writeBoolean(this.frozen);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        byte hours = s.readByte();
        byte minutes = s.readByte();
        byte seconds = s.readByte();
        short millis = s.readShort();
        this.cal = Calendar.getInstance();
        this.cal.set(1970, 0, 1, hours, minutes, seconds);
        this.cal.set(14, millis);
        super.setTime(this.cal.getTimeInMillis());
        this.frozen = s.readBoolean();
    }
}

