/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.common;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.tentackle.common.CommonCommonBundle;
import org.tentackle.common.DefaultStringNormalizer;
import org.tentackle.common.TentackleRuntimeException;

public final class StringHelper {
    public static int maxLogCollectionSize = 10;
    private static final String CRITS = "\u00c4\u00c0\u00c1\u00c2\u00c3\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d6\u00d2\u00d3\u00d4\u00d5\u00d7\u00d8\u00dc\u00d9\u00da\u00db\u00dd\u00de\u00e4\u00e0\u00e1\u00e2\u00e3\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f6\u00f0\u00f2\u00f3\u00f4\u00f5\u00f8\u00fc\u00f9\u00fa\u00fb\u00fd\u00fe\u00ff\u00df";
    private static final String NORMS = "AAAAAAACEEEEIIIIDNOOOOOXOUUUUYBaaaaaaaceeeeiiiinooooooouuuuybys";
    private static char[] critMap;
    private static final byte[] EMPTY_BYTES;
    private static final String[] JAVA_RESERVED_WORDS;
    public static Function<String, String> stringNormalizer;
    private static final char[] HEX_DIGITS;

    public static boolean equalsIgnoreCase(String a, String b) {
        return a == b || a != null && a.equalsIgnoreCase(b);
    }

    public static String toUpper(String str) {
        if (str != null) {
            str = str.toUpperCase();
        }
        return str;
    }

    public static String toLower(String str) {
        if (str != null) {
            str = str.toLowerCase();
        }
        return str;
    }

    public static String firstToUpper(String str) {
        if (str != null && str.length() > 0) {
            StringBuilder buf = new StringBuilder(str);
            buf.deleteCharAt(0);
            buf.insert(0, Character.toUpperCase(str.charAt(0)));
            return buf.toString();
        }
        return null;
    }

    public static String firstToLower(String str) {
        if (str != null && str.length() > 0) {
            StringBuilder buf = new StringBuilder(str);
            buf.deleteCharAt(0);
            buf.insert(0, Character.toLowerCase(str.charAt(0)));
            return buf.toString();
        }
        return null;
    }

    public static String getPlainClassName(String className) {
        int ndx = className.indexOf(60);
        if (ndx > 0) {
            return className.substring(0, ndx).trim();
        }
        return className;
    }

    public static String getContinuedLine(String line) {
        int len;
        if (line != null && (len = line.length()) > 0 && line.charAt(len - 1) == '\\') {
            int ndx = len - 1;
            int slashCount = 1;
            while (--ndx >= 0 && line.charAt(ndx) == '\\') {
                ++slashCount;
            }
            if (slashCount & true) {
                return line.substring(0, len - 1);
            }
        }
        return null;
    }

    public static int indexAnyOf(String str, String anyOf) {
        int index = -1;
        if (anyOf != null && str != null) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (anyOf.indexOf(c) < 0) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static String toDoubleQuotes(String str) {
        StringBuilder buf = new StringBuilder();
        buf.append('\"');
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c == '\"' || c == '\\') {
                    buf.append('\\');
                } else if (Character.isISOControl(c)) {
                    c = ' ';
                }
                buf.append(c);
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String parseString(String str) {
        StringBuilder buf = new StringBuilder();
        if (str != null && str.length() > 0) {
            char quoteChar = str.charAt(0);
            if (quoteChar != '\"' && quoteChar != '\'') {
                quoteChar = '\u0000';
            }
            if (quoteChar != '\u0000') {
                char lastChar = str.charAt(str.length() - 1);
                if (lastChar != quoteChar || str.length() < 2) {
                    throw new TentackleRuntimeException("String <" + str + "> contains unbalanced quotes");
                }
                str = str.substring(1, str.length() - 1);
            }
            boolean escaped = false;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (escaped) {
                    switch (c) {
                        case 'n': {
                            buf.append('\n');
                            break;
                        }
                        case 'r': {
                            buf.append('\r');
                            break;
                        }
                        case 't': {
                            buf.append('\t');
                            break;
                        }
                        case 'f': {
                            buf.append('\f');
                            break;
                        }
                        default: {
                            buf.append(c);
                        }
                    }
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                buf.append(c);
            }
        }
        return buf.toString();
    }

    public static String toParsableString(String str) {
        StringBuilder buf = new StringBuilder();
        boolean needQuotes = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\'' || c == '\"' || c == '\\') {
                buf.append('\\').append(c);
                needQuotes = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                needQuotes = true;
                switch (c) {
                    case '\n': {
                        buf.append("\\n");
                        break;
                    }
                    case '\r': {
                        buf.append("\\r");
                        break;
                    }
                    case '\t': {
                        buf.append("\\t");
                        break;
                    }
                    case '\f': {
                        buf.append("\\f");
                        break;
                    }
                    default: {
                        buf.append(c);
                        break;
                    }
                }
                continue;
            }
            buf.append(c);
        }
        if (needQuotes) {
            buf.insert(0, '\"');
            buf.append('\"');
        }
        return buf.toString();
    }

    public static List<String> split(String str, String delimiters) {
        ArrayList<String> parts = new ArrayList<String>();
        if (str != null) {
            StringBuilder part = null;
            boolean escaped = false;
            char quoteChar = '\u0000';
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (escaped) {
                    switch (c) {
                        case 'n': {
                            part.append('\n');
                            break;
                        }
                        case 'r': {
                            part.append('\r');
                            break;
                        }
                        case 't': {
                            part.append('\t');
                            break;
                        }
                        case 'f': {
                            part.append('\f');
                            break;
                        }
                        default: {
                            part.append(c);
                        }
                    }
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    if (part != null) continue;
                    part = new StringBuilder();
                    continue;
                }
                if (c == '\'' || c == '\"') {
                    if (part == null) {
                        part = new StringBuilder();
                        part.append(c);
                        quoteChar = c;
                        continue;
                    }
                    if (quoteChar != '\u0000' && quoteChar != c) {
                        part.append(c);
                        continue;
                    }
                    part.append(c);
                    parts.add(part.toString());
                    part = null;
                    quoteChar = '\u0000';
                    continue;
                }
                if (delimiters.indexOf(c) >= 0) {
                    if (quoteChar == '\u0000') {
                        if (part == null) continue;
                        parts.add(part.toString());
                        part = null;
                        continue;
                    }
                    part.append(c);
                    continue;
                }
                if (part == null) {
                    part = new StringBuilder();
                }
                part.append(c);
            }
            if (part != null) {
                parts.add(part.toString());
            }
        }
        return parts;
    }

    public static boolean isFQCN(String className) {
        return className.contains(".") && StringHelper.isValidJavaClassName(className);
    }

    public static boolean isValidJavaClassName(String className) {
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex > 0) {
            String packageName = className.substring(0, dotIndex);
            className = className.substring(dotIndex + 1);
            if (!StringHelper.isValidJavaPackageName(packageName)) {
                return false;
            }
        }
        if (className.length() < 1) {
            return false;
        }
        char firstChar = className.charAt(0);
        if (!Character.isAlphabetic(firstChar) || !Character.isUpperCase(firstChar)) {
            return false;
        }
        for (int pos = 0; pos < className.length(); ++pos) {
            char c = className.charAt(pos);
            if (Character.isAlphabetic(c) || Character.isDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaPackageName(String packageName) {
        boolean lastWasDot = true;
        for (int pos = 0; pos < packageName.length(); ++pos) {
            char c = packageName.charAt(pos);
            if (c == '.') {
                lastWasDot = true;
                continue;
            }
            if (lastWasDot) {
                lastWasDot = false;
                if (!Character.isDigit(c)) continue;
                return false;
            }
            if (Character.isDigit(c) || !Character.isUpperCase(c) && (Character.isAlphabetic(c) || c == '_')) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidJavaIdentifier(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        char[] c = str.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    public static String readTextFromResource(String resourceName) throws IOException {
        InputStream is = StringHelper.class.getResourceAsStream(resourceName);
        if (is == null && (is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName)) == null) {
            throw new FileNotFoundException("no such resource: " + resourceName);
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line;
            StringBuilder buf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            String string = buf.toString();
            return string;
        }
    }

    public static boolean isAllWhitespace(String str) {
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isReservedWord(String word) {
        if (word != null) {
            for (String rw : JAVA_RESERVED_WORDS) {
                if (!rw.equals(word)) continue;
                return true;
            }
        }
        return false;
    }

    public static String digitToString(Character digit) {
        return CommonCommonBundle.getString(String.valueOf(digit));
    }

    /*
     * Unable to fully structure code
     */
    public static String unDiacrit(String str, boolean keepLength) {
        block16: {
            try {
                mapLen = StringHelper.critMap.length >> 1;
            }
            catch (NullPointerException e) {
                mapLen = "\u00c4\u00c0\u00c1\u00c2\u00c3\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d6\u00d2\u00d3\u00d4\u00d5\u00d7\u00d8\u00dc\u00d9\u00da\u00db\u00dd\u00de\u00e4\u00e0\u00e1\u00e2\u00e3\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f6\u00f0\u00f2\u00f3\u00f4\u00f5\u00f8\u00fc\u00f9\u00fa\u00fb\u00fd\u00fe\u00ff\u00df".length();
                if (mapLen != "AAAAAAACEEEEIIIIDNOOOOOXOUUUUYBaaaaaaaceeeeiiiinooooooouuuuybys".length()) {
                    throw new IllegalStateException();
                }
                StringHelper.critMap = new char[mapLen + mapLen];
                for (i = 0; i < mapLen; ++i) {
                    StringHelper.critMap[i] = "\u00c4\u00c0\u00c1\u00c2\u00c3\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d6\u00d2\u00d3\u00d4\u00d5\u00d7\u00d8\u00dc\u00d9\u00da\u00db\u00dd\u00de\u00e4\u00e0\u00e1\u00e2\u00e3\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f6\u00f0\u00f2\u00f3\u00f4\u00f5\u00f8\u00fc\u00f9\u00fa\u00fb\u00fd\u00fe\u00ff\u00df".charAt(i);
                    StringHelper.critMap[i + mapLen] = "AAAAAAACEEEEIIIIDNOOOOOXOUUUUYBaaaaaaaceeeeiiiinooooooouuuuybys".charAt(i);
                }
            }
            if (str == null) break block16;
            buf = new StringBuilder();
            len = str.length();
            block12: for (i = 0; i < len; ++i) {
                c = str.charAt(i);
                if (keepLength) ** GOTO lbl-1000
                switch (c) {
                    case '\u00c4': 
                    case '\u00c6': {
                        buf.append(i < len - 1 && Character.isUpperCase(str.charAt(i + 1)) != false ? "AE" : "Ae");
                        continue block12;
                    }
                    case '\u00dc': {
                        buf.append(i < len - 1 && Character.isUpperCase(str.charAt(i + 1)) != false ? "UE" : "Ue");
                        continue block12;
                    }
                    case '\u00d6': {
                        buf.append(i < len - 1 && Character.isUpperCase(str.charAt(i + 1)) != false ? "OE" : "Oe");
                        continue block12;
                    }
                    case '\u00e4': 
                    case '\u00e6': {
                        buf.append("ae");
                        continue block12;
                    }
                    case '\u00fc': {
                        buf.append("ue");
                        continue block12;
                    }
                    case '\u00f6': {
                        buf.append("oe");
                        continue block12;
                    }
                    case '\u00df': {
                        buf.append("ss");
                        continue block12;
                    }
                    default: lbl-1000:
                    // 3 sources

                    {
                        for (m = 0; m < mapLen; ++m) {
                            if (StringHelper.critMap[m] != c) continue;
                            c = StringHelper.critMap[m + mapLen];
                            break;
                        }
                        if (c >= ' ' && c <= '\u007f') {
                            buf.append(c);
                            continue block12;
                        }
                        if (!keepLength) continue block12;
                        buf.append('?');
                    }
                }
            }
            return buf.toString();
        }
        return null;
    }

    public static String normalize(String str, Function<String, String> normalizer) {
        return normalizer == null ? stringNormalizer.apply(str) : normalizer.apply(str);
    }

    public static String normalize(String str) {
        return StringHelper.normalize(str, null);
    }

    public static String stripEnclosingDoubleQuotes(String str) {
        if (str != null && !str.isEmpty()) {
            if (str.charAt(0) == '\"') {
                str = str.substring(1);
            }
            if (!str.isEmpty() && str.charAt(str.length() - 1) == '\"') {
                str = str.substring(0, str.length() - 1);
            }
        }
        return str;
    }

    public static String toFixedLength(String str, int length, char filler) {
        int len = 0;
        StringBuilder buf = new StringBuilder();
        if (str != null) {
            len = str.length();
            if (len > length) {
                buf.append(str.substring(0, length));
                len = length;
            } else {
                buf.append(str);
            }
        }
        while (len < length) {
            buf.append(filler);
            ++len;
        }
        return buf.toString();
    }

    public static String toFixedLength(String str, int length) {
        return StringHelper.toFixedLength(str, length, ' ');
    }

    public static String toFixedLengthLeftFill(String str, int length, char filler) {
        int len = 0;
        StringBuilder buf = new StringBuilder();
        if (str != null) {
            len = str.length();
            if (len > length) {
                buf.append(str.substring(0, length));
                len = length;
            } else {
                buf.append(str);
            }
        }
        while (len < length) {
            buf.insert(0, filler);
            ++len;
        }
        return buf.toString();
    }

    public static String toFixedLengthLeftFill(String str, int length) {
        return StringHelper.toFixedLengthLeftFill(str, length, ' ');
    }

    public static String toDTA(String str) {
        if (str != null) {
            str = str.toUpperCase();
            int len = str.length();
            StringBuilder sbuf = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == ' ' || c == '.' || c == ',' || c == '&' || c == '-' || c == '/' || c == '+' || c == '*' || c == '$' || c == '%' || c == '\u00c4' || c == '\u00d6' || c == '\u00dc' || c == '\u00df') {
                    sbuf.append(c);
                    continue;
                }
                sbuf.append(' ');
            }
            str = sbuf.toString();
        }
        return str;
    }

    public static String toVarName(String str) {
        if (str != null) {
            int len = str.length();
            StringBuilder sbuf = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                    sbuf.append(c);
                    continue;
                }
                if (c != '_' && !Character.isWhitespace(c)) continue;
                sbuf.append('_');
            }
            str = sbuf.toString();
        }
        return str;
    }

    public static boolean isAllDigits(String str, boolean whitespaceAllowed) {
        if (str != null) {
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (Character.isDigit(c) || whitespaceAllowed && Character.isWhitespace(c)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isAllDigits(String str) {
        return StringHelper.isAllDigits(str, false);
    }

    public static String trim(String s, int max) {
        if (s != null) {
            s = s.trim();
            if (max > 0 && s.length() > max) {
                s = s.substring(0, max);
            }
        }
        return s;
    }

    public static String trim(String s) {
        return StringHelper.trim(s, 0);
    }

    public static String trimRight(String str, char filler) {
        if (str == null) {
            str = "";
        } else if (!str.isEmpty()) {
            char c;
            int i = str.length();
            while (--i >= 0 && (c = str.charAt(i)) == filler) {
            }
            str = str.substring(0, i + 1);
        }
        return str;
    }

    public static String trimLeft(String str, char filler) {
        if (str == null) {
            str = "";
        } else {
            StringBuilder buf = new StringBuilder();
            boolean fillerFound = false;
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!fillerFound && c == filler) continue;
                buf.append(c);
                fillerFound = true;
            }
            str = buf.toString();
        }
        return str;
    }

    public static String fillLeft(String str, int length, char filler) {
        int diff = length - (str == null ? 0 : str.length());
        if (diff > 0) {
            StringBuilder buf = new StringBuilder();
            while (diff-- > 0) {
                buf.append(filler);
            }
            if (str != null) {
                buf.append(str);
            }
            str = buf.toString();
        } else if (diff == 0 && str == null) {
            str = "";
        }
        return str;
    }

    public static String fillRight(String str, int length, char filler) {
        int diff = length - (str == null ? 0 : str.length());
        if (diff > 0) {
            StringBuilder buf = new StringBuilder();
            if (str != null) {
                buf.append(str);
            }
            while (diff-- > 0) {
                buf.append(filler);
            }
            str = buf.toString();
        } else if (diff == 0 && str == null) {
            str = "";
        }
        return str;
    }

    public static String firstBefore(String str, char delimiter) {
        int ndx;
        if (str != null && (ndx = str.indexOf(delimiter)) >= 0) {
            str = str.substring(0, ndx);
        }
        return str;
    }

    public static String lastAfter(String str, char delimiter) {
        int ndx;
        if (str != null && (ndx = str.lastIndexOf(delimiter)) >= 0) {
            str = str.substring(ndx + 1);
        }
        return str;
    }

    public static String firstLine(String str) {
        return StringHelper.firstBefore(str, '\n');
    }

    public static String toHexString(byte[] binaryData) {
        if (binaryData != null) {
            char[] text = new char[binaryData.length << 1];
            int j = 0;
            for (byte b : binaryData) {
                text[j++] = HEX_DIGITS[(b & 0xF0) >> 4];
                text[j++] = HEX_DIGITS[b & 0xF];
            }
            return new String(text);
        }
        return null;
    }

    public static byte[] toBytes(char c) {
        return new byte[]{(byte)(c & 0xFF), (byte)(c >> 8 & 0xFF)};
    }

    public static byte[] toBytes(char[] chars) {
        if (chars != null) {
            byte[] b = new byte[chars.length << 1];
            int j = 0;
            for (char c : chars) {
                b[j++] = (byte)(c & 0xFF);
                b[j++] = (byte)(c >> 8 & 0xFF);
            }
            return b;
        }
        return EMPTY_BYTES;
    }

    public static String hash(String algorithm, char[] salt, char[] input) {
        if (input != null) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                byte[] inputBytes = StringHelper.toBytes(input);
                if (salt != null && salt.length > 0 && input.length > 0) {
                    byte[] saltyBytes = StringHelper.toBytes(salt);
                    byte[] saltyInputBytes = new byte[saltyBytes.length + inputBytes.length];
                    System.arraycopy(saltyBytes, 0, saltyInputBytes, 0, saltyBytes.length);
                    System.arraycopy(inputBytes, 0, saltyInputBytes, saltyBytes.length, inputBytes.length);
                    inputBytes = saltyInputBytes;
                }
                return StringHelper.toHexString(md.digest(inputBytes));
            }
            catch (NoSuchAlgorithmException e) {
                throw new TentackleRuntimeException("hashing failed", e);
            }
        }
        return null;
    }

    public static String objectToLoggableString(Object object) {
        if (object == null) {
            return "<null>";
        }
        if (object instanceof String) {
            String str = (String)object;
            StringBuilder buf = new StringBuilder();
            buf.append('\"');
            if (str.indexOf(10) >= 0) {
                buf.append(StringHelper.firstLine(str));
                buf.append("...");
            } else {
                buf.append(str);
            }
            buf.append('\"');
            return buf.toString();
        }
        if (maxLogCollectionSize > 0 && object instanceof Collection && ((Collection)object).size() > maxLogCollectionSize) {
            return "[" + ((Collection)object).size() + " items]";
        }
        return object.toString();
    }

    public static int countOccurrences(String str, char c) {
        int count = 0;
        if (str != null && str.length() > 0) {
            int ndx = 0;
            while (ndx >= 0) {
                if ((ndx = str.indexOf(c, ndx + 1)) <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public static String objectArrayToString(Object[] objArray, String separator) {
        StringBuilder buf = new StringBuilder();
        if (objArray != null) {
            boolean addSeparator = false;
            for (Object obj : objArray) {
                if (addSeparator) {
                    buf.append(separator);
                }
                buf.append(StringHelper.objectToLoggableString(obj));
                addSeparator = true;
            }
        }
        return buf.toString();
    }

    public static char[] toCharArray(String str) {
        return str == null ? null : str.toCharArray();
    }

    public static void fill(char[] buf, char val) {
        if (buf != null) {
            Arrays.fill(buf, val);
        }
    }

    public static void blank(char[] buf) {
        StringHelper.fill(buf, ' ');
    }

    public static String toHTML(String text) {
        StringBuilder buf = new StringBuilder("<HTML>");
        if (text != null) {
            buf.append(text.replace("\n", "<BR>"));
        }
        buf.append("</HTML>");
        return buf.toString();
    }

    public static String removeTrailingText(String str, String trail) {
        if (str.endsWith(trail)) {
            str = str.substring(0, str.length() - trail.length());
        }
        return str;
    }

    public static String toAsciiLetterOrDigit(String str) {
        if (str != null) {
            StringBuilder buf = new StringBuilder(StringHelper.unDiacrit(str, false));
            boolean wasUnderscore = false;
            for (int i = 0; i < buf.length(); ++i) {
                char c = buf.charAt(i);
                if (!(c != '_' && (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9'))) {
                    if (wasUnderscore) {
                        buf.deleteCharAt(i--);
                        continue;
                    }
                    buf.setCharAt(i, '_');
                    wasUnderscore = true;
                    continue;
                }
                wasUnderscore = false;
            }
            return buf.toString();
        }
        return null;
    }

    private StringHelper() {
    }

    static {
        EMPTY_BYTES = new byte[0];
        JAVA_RESERVED_WORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "double", "do", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
        stringNormalizer = new DefaultStringNormalizer();
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

