/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.domain;

import java.io.Serializable;
import java.util.List;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainException;
import org.tentackle.pdo.DomainObject;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistenceDelegate;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.EffectiveClassProvider;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.session.Session;

public abstract class AbstractDomainObject<T extends PersistentDomainObject<T>, D extends AbstractDomainObject<T, D>>
implements DomainObject<T>,
EffectiveClassProvider<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private T pdo;

    public AbstractDomainObject(T pdo) {
        this.pdo = pdo;
    }

    public AbstractDomainObject() {
    }

    public PersistenceDelegate<T> getPersistenceDelegate() {
        return this.pdo.getPersistenceDelegate();
    }

    public T getPdo() {
        return this.pdo;
    }

    public T me() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.pdo = pdo;
    }

    public Class<T> getEffectiveClass() {
        return this.pdo.getEffectiveClass();
    }

    public List<Class<? super T>> getEffectiveSuperClasses() {
        return this.pdo.getEffectiveSuperClasses();
    }

    public DomainContext getDomainContext() {
        return this.pdo.getPersistenceDelegate().getDomainContext();
    }

    public Session getSession() {
        return this.pdo.getPersistenceDelegate().getSession();
    }

    public String toGenericString() {
        return this.getClass().getName() + "[" + this.me().getId() + "/" + this.me().getSerial() + "]";
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        try {
            Object key;
            Object object = key = this.me().isRootEntity() ? this.getUniqueDomainKey() : this.getSingular();
            if (key != null) {
                buf.append(key);
            }
        }
        catch (RuntimeException re) {
            buf.append(this.toGenericString());
            buf.append("(");
            buf.append(re);
            buf.append(")");
        }
        return buf.toString();
    }

    public boolean isUniqueDomainKeyProvided() {
        return false;
    }

    public Class<?> getUniqueDomainKeyType() {
        this.assertRootEntity();
        throw new DomainException(this.pdo, "method getUniqueDomainKeyType not implemented in " + this.getClass());
    }

    public Object getUniqueDomainKey() {
        this.assertRootEntity();
        throw new DomainException(this.pdo, "method getUniqueDomainKey not implemented in " + this.getClass());
    }

    public void setUniqueDomainKey(Object domainKey) {
        this.assertRootEntity();
        throw new DomainException(this.pdo, "method setUniqueDomainKey not implemented in " + this.getClass());
    }

    public T findByUniqueDomainKey(Object domainKey) {
        this.assertRootEntity();
        throw new DomainException(this.pdo, "method findByUniqueDomainKey not implemented in " + this.getClass());
    }

    public String getSingular() {
        String name = PdoUtilities.getInstance().getSingular(this.me().getEffectiveClass());
        if (name == null) {
            name = ReflectionHelper.getClassBaseName((Class)this.me().getEffectiveClass());
        }
        return name;
    }

    public String getPlural() {
        Object name = PdoUtilities.getInstance().getPlural(this.me().getEffectiveClass());
        if (name == null) {
            name = (String)name + (((String)(name = this.getSingular())).endsWith("s") ? "es" : "s");
        }
        return name;
    }

    public void assertRootEntity() {
        if (!this.me().getPersistenceDelegate().isRootEntity()) {
            throw new DomainException(this.me(), "not a root-entity");
        }
    }
}

