/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.pdo;

import java.io.Serializable;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainException;
import org.tentackle.pdo.DomainObject;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistenceDelegate;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.pdo.Session;
import org.tentackle.reflect.ReflectionHelper;

public abstract class AbstractDomainObject<T extends PersistentDomainObject<T>, D extends AbstractDomainObject<T, D>>
implements DomainObject<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private T pdo;

    public AbstractDomainObject(T pdo) {
        this.pdo = pdo;
    }

    public AbstractDomainObject() {
    }

    public PersistenceDelegate<T> getPersistenceDelegate() {
        return this.pdo.getPersistenceDelegate();
    }

    public T getPdo() {
        return this.pdo;
    }

    public T pdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.pdo = pdo;
    }

    public DomainContext getDomainContext() {
        return this.pdo.getPersistenceDelegate().getDomainContext();
    }

    public Session getSession() {
        return this.pdo.getPersistenceDelegate().getSession();
    }

    public String toGenericString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName());
        buf.append('[');
        buf.append(this.pdo().getId());
        buf.append('/');
        buf.append(this.pdo().getSerial());
        buf.append(']');
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        try {
            Object key;
            Object object = key = this.pdo().isRootEntity() ? this.pdo().getUniqueDomainKey() : this.getSingular();
            if (key != null) {
                buf.append(key);
            }
        }
        catch (RuntimeException re) {
            buf.append(this.toGenericString());
            buf.append("(");
            buf.append(re);
            buf.append(")");
        }
        return buf.toString();
    }

    public D clone() {
        AbstractDomainObject obj;
        try {
            obj = (AbstractDomainObject)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        obj.setPdo(null);
        return (D)obj;
    }

    public DomainObject<T> cloneDomainObject() {
        return this.clone();
    }

    public boolean isUniqueDomainKeyProvided() {
        return false;
    }

    public Class<?> getUniqueDomainKeyType() {
        this.assertRootEntity();
        throw new DomainException(this.pdo, "method getUniqueDomainKeyType not implemented in " + this.getClass());
    }

    public Object getUniqueDomainKey() {
        this.assertRootEntity();
        throw new DomainException(this.pdo, "method getUniqueDomainKey not implemented in " + this.getClass());
    }

    public void setUniqueDomainKey(Object domainKey) {
        this.assertRootEntity();
        throw new DomainException(this.pdo, "method setUniqueDomainKey not implemented in " + this.getClass());
    }

    public T findByUniqueDomainKey(Object domainKey) {
        this.assertRootEntity();
        throw new DomainException(this.pdo, "method findByUniqueDomainKey not implemented in " + this.getClass());
    }

    public String getSingular() {
        String name = PdoUtilities.getInstance().getSingular(this.pdo().getEffectiveClass());
        if (name == null) {
            name = ReflectionHelper.getClassBaseName((Class)this.pdo().getEffectiveClass());
        }
        return name;
    }

    public String getPlural() {
        String name = PdoUtilities.getInstance().getPlural(this.pdo().getEffectiveClass());
        if (name == null) {
            name = this.getSingular();
            name = name + (name.endsWith("s") ? "es" : "s");
        }
        return name;
    }

    public void assertRootEntity() {
        if (!this.pdo().isRootEntity()) {
            throw new DomainException(this.pdo(), "not a root-entity");
        }
    }
}

