/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.domain.security;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.tentackle.domain.AbstractDomainObject;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainObjectService;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.pdo.Security;
import org.tentackle.security.pdo.SecurityDomain;
import org.tentackle.session.SessionUtilities;

@DomainObjectService(value=Security.class)
public class SecurityDomainImpl
extends AbstractDomainObject<Security, SecurityDomainImpl>
implements SecurityDomain {
    private static final long serialVersionUID = 1L;
    private Class<? extends Permission>[] permissions;

    public SecurityDomainImpl(Security pdo) {
        super(pdo);
    }

    public SecurityDomainImpl() {
    }

    @Override
    public Object getUniqueDomainKey() {
        return ((Security)this.getPdo()).getId();
    }

    @Override
    public Security findByUniqueDomainKey(Object domainKey) {
        return (Security)((Security)this.getPdo()).select(((Long)domainKey).longValue());
    }

    public boolean evaluate(DomainContext context, Permission permission) {
        return (context == null || context.isWithinContext(((Security)this.pdo()).getDomainContextId(), ((Security)this.pdo()).getDomainContextClassId())) && (((Security)this.pdo()).isAllowed() ? permission.isAllowedBy((Class[])this.getPermissions()) : permission.isDeniedBy((Class[])this.getPermissions()));
    }

    public String securableToString() {
        StringBuilder buf = new StringBuilder();
        if (((Security)this.pdo()).getObjectClassId() != 0) {
            String className = SessionUtilities.getInstance().getClassName(((Security)this.pdo()).getObjectClassId());
            PersistentDomainObject securedPdo = Pdo.create((String)className, (DomainContext)this.getDomainContext());
            if (((Security)this.pdo()).getObjectId() != 0L) {
                buf.append(securedPdo.getSingular()).append(' ');
                PersistentDomainObject sobj = securedPdo.select(((Security)this.pdo()).getObjectId());
                if (sobj == null) {
                    buf.append("<?").append(((Security)this.pdo()).getObjectId()).append("?>");
                } else {
                    buf.append(sobj);
                }
            } else {
                buf.append(securedPdo.getPlural());
            }
        } else if (((Security)this.pdo()).getObjectClassName() != null) {
            buf.append(ReflectionHelper.getClassBaseName((String)((Security)this.pdo()).getObjectClassName()));
        }
        return buf.toString();
    }

    public String granteeToString() {
        StringBuilder buf = new StringBuilder();
        PersistentDomainObject grantee = ((Security)this.pdo()).getGrantee();
        if (grantee != null) {
            buf.append(grantee.getSingular()).append(' ').append(grantee);
        }
        return buf.toString();
    }

    public String contextToString() {
        PersistentDomainObject contextPdo = ((Security)this.pdo()).getDomainContextObject();
        return contextPdo == null ? null : contextPdo.toString();
    }

    protected Class<? extends Permission>[] getPermissions() {
        if (this.permissions == null) {
            if (((Security)this.pdo()).getPermissions() == null) {
                this.permissions = new Class[0];
            } else {
                StringTokenizer stok = new StringTokenizer(((Security)this.pdo()).getPermissions(), ", ");
                ArrayList<Class> perms = new ArrayList<Class>();
                while (stok.hasMoreTokens()) {
                    String permissionName = stok.nextToken();
                    Class permission = SecurityFactory.getInstance().getPermissionInterface(permissionName);
                    if (permission == null) {
                        throw new SecurityException("unknown permission '" + permissionName + "'");
                    }
                    perms.add(permission);
                }
                this.permissions = perms.toArray(new Class[perms.size()]);
            }
        }
        return this.permissions;
    }
}

