/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.domain.ns;

import java.util.Iterator;
import org.tentackle.domain.AbstractDomainObject;
import org.tentackle.ns.NumberSourceEmptyException;
import org.tentackle.ns.pdo.NumberPool;
import org.tentackle.ns.pdo.NumberPoolDomain;
import org.tentackle.ns.pdo.NumberRange;
import org.tentackle.pdo.DomainObjectService;

@DomainObjectService(value=NumberPool.class)
public class NumberPoolDomainImpl
extends AbstractDomainObject<NumberPool, NumberPoolDomainImpl>
implements NumberPoolDomain {
    private static final long serialVersionUID = 1L;

    public NumberPoolDomainImpl(NumberPool pdo) {
        super(pdo);
    }

    public NumberPoolDomainImpl() {
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(((NumberPool)this.me()).getName());
        if (((NumberPool)this.me()).getRealm() != null) {
            buf.append(':').append(((NumberPool)this.me()).getRealm());
        }
        return buf.toString();
    }

    public NumberRange getCurrentRange() {
        NumberRange currentRange = null;
        Iterator iter = ((NumberPool)this.me()).getNumberRangeList().iterator();
        while (iter.hasNext()) {
            NumberRange range = (NumberRange)iter.next();
            if (range.isEmpty()) {
                iter.remove();
                continue;
            }
            if (currentRange != null && currentRange.getBegin() <= range.getBegin()) continue;
            currentRange = range;
        }
        if (currentRange == null) {
            throw new NumberSourceEmptyException("pool " + String.valueOf(this) + " is empty");
        }
        return currentRange;
    }

    public boolean isSlave() {
        return ((NumberPool)this.me()).getLowWaterMark() > 0L && ((NumberPool)this.me()).getRequestSize() > 0L;
    }
}

