/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.domain.ns;

import org.tentackle.domain.AbstractDomainObject;
import org.tentackle.ns.NumberSource;
import org.tentackle.ns.NumberSourceEmptyException;
import org.tentackle.ns.pdo.NumberRange;
import org.tentackle.ns.pdo.NumberRangeDomain;
import org.tentackle.pdo.DomainObjectService;

@DomainObjectService(value=NumberRange.class)
public class NumberRangeDomainImpl
extends AbstractDomainObject<NumberRange, NumberRangeDomainImpl>
implements NumberRangeDomain {
    private static final long serialVersionUID = 1L;

    public NumberRangeDomainImpl(NumberRange pdo) {
        super(pdo);
    }

    public NumberRangeDomainImpl() {
    }

    @Override
    public String toString() {
        return String.valueOf(((NumberRange)this.me()).getNumberPool()) + '[' + ((NumberRange)this.me()).getBegin() + ',' + ((NumberRange)this.me()).getEnd() + ']';
    }

    public long size() {
        long size = ((NumberRange)this.me()).getEnd() - ((NumberRange)this.me()).getBegin();
        if (size < 0L) {
            size = 0L;
        }
        return size;
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public long popNumber() {
        this.assertNotEmpty();
        long number = ((NumberRange)this.me()).getBegin();
        ((NumberRange)this.me()).setBegin(number + 1L);
        return number;
    }

    public NumberSource.Range popNumbers(long count) {
        this.assertNotEmpty();
        long size = this.size();
        if (count > size) {
            count = size;
        }
        NumberSource.Range range = new NumberSource.Range(((NumberRange)this.me()).getBegin(), ((NumberRange)this.me()).getBegin() + count);
        ((NumberRange)this.me()).setBegin(range.getEnd());
        return range;
    }

    public boolean intersects(long begin, long end) {
        return begin < ((NumberRange)this.me()).getEnd() && end > ((NumberRange)this.me()).getBegin();
    }

    protected void assertNotEmpty() {
        if (this.isEmpty()) {
            throw new NumberSourceEmptyException("range " + this + " is empty");
        }
    }
}

