/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.poi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javafx.stage.Stage;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.tentackle.common.BMoney;
import org.tentackle.common.ClasspathFirst;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.bind.FxTableBinding;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.RdcUtilities;
import org.tentackle.fx.rdc.table.TableUtilities;
import org.tentackle.fx.table.TableColumnConfiguration;

@Service(value=TableUtilities.class)
@ClasspathFirst(value=TableUtilities.class)
public class PoiTableUtilities
extends TableUtilities {
    private static final String SPREADSHEET_EXTENSION = ".xls";
    private static final String LAST_SPREADSHEET_PREFIX = "lastXlsNames/";
    private static final String SPREADSHEET_KEY = "path";

    public File selectSpreadsheetFile(String tableName, Stage owner) {
        return RdcUtilities.getInstance().selectFile(StringHelper.trimRight((String)(LAST_SPREADSHEET_PREFIX + tableName), (char)'/'), SPREADSHEET_KEY, SPREADSHEET_EXTENSION, RdcFxRdcBundle.getString((String)"SPREADSHEET FILE"), owner);
    }

    protected <S> void toSpreadsheet(Collection<TableColumnConfiguration<S, ?>> columnConfigurations, File file, List<S> items) {
        try (HSSFWorkbook wb = new HSSFWorkbook();){
            HSSFSheet sheet = wb.createSheet();
            int srow = 0;
            HSSFRow row = sheet.createRow(srow++);
            HSSFFont font = wb.createFont();
            font.setItalic(true);
            font.setBold(true);
            HSSFCellStyle cs = wb.createCellStyle();
            cs.setAlignment(HorizontalAlignment.CENTER);
            cs.setFont(font);
            int columnIndex = 0;
            for (TableColumnConfiguration<S, ?> tc : columnConfigurations) {
                if (!this.isColumnVisible(tc)) continue;
                HSSFCell cell = row.createCell(columnIndex);
                cell.setCellValue((RichTextString)new HSSFRichTextString(tc.getDisplayedName()));
                cell.setCellStyle(cs);
                ++columnIndex;
            }
            HSSFCellStyle dateStyle = wb.createCellStyle();
            dateStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy"));
            ArrayList<HSSFCellStyle> numberStyles = new ArrayList<HSSFCellStyle>();
            HSSFDataFormat format = wb.createDataFormat();
            for (S item : items) {
                row = sheet.createRow(srow++);
                columnIndex = 0;
                for (TableColumnConfiguration<S, ?> tc : columnConfigurations) {
                    if (!this.isColumnVisible(tc)) continue;
                    FxTableBinding binding = tc.getBinding();
                    if (binding != null) {
                        binding.setBoundRootObject(item);
                        Object value = binding.getModelValue();
                        HSSFCell cell = row.createCell(columnIndex);
                        if (value instanceof Boolean) {
                            Boolean boolValue = (Boolean)value;
                            cell.setCellValue(boolValue.booleanValue());
                        } else if (value instanceof BMoney) {
                            BMoney money = (BMoney)value;
                            cell.setCellValue(money.doubleValue());
                            Object fmt = "#,##0";
                            if (money.scale() > 0) {
                                fmt = (String)fmt + "." + "0".repeat(money.scale());
                            }
                            short fmtIndex = format.getFormat((String)fmt);
                            Iterator iter = numberStyles.iterator();
                            boolean found = false;
                            while (iter.hasNext()) {
                                cs = (HSSFCellStyle)iter.next();
                                if (cs.getDataFormat() != fmtIndex) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                cs = wb.createCellStyle();
                                cs.setDataFormat(fmtIndex);
                                numberStyles.add(cs);
                            }
                            cell.setCellStyle(cs);
                        } else if (value instanceof Number) {
                            cell.setCellValue(((Number)value).doubleValue());
                        } else if (value instanceof Date) {
                            cell.setCellValue((Date)value);
                            cell.setCellStyle(dateStyle);
                        } else if (value instanceof Calendar) {
                            cell.setCellValue((Calendar)value);
                            cell.setCellStyle(dateStyle);
                        } else if (value != null) {
                            cell.setCellValue((RichTextString)new HSSFRichTextString(value.toString()));
                        }
                    }
                    ++columnIndex;
                }
            }
            try (FileOutputStream fileOut = new FileOutputStream(file);){
                wb.write((OutputStream)fileOut);
            }
        }
        catch (IOException ex) {
            throw new FxRuntimeException("creating spreadsheet file failed", (Throwable)ex);
        }
    }
}

