/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.app;

import java.text.MessageFormat;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.tentackle.app.AbstractClientApplication;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxController;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.rdc.app.AppFxRdcBundle;
import org.tentackle.fx.rdc.app.FxApplication;
import org.tentackle.fx.rdc.app.LoginApplication;
import org.tentackle.fx.rdc.app.LoginFailedHandler;
import org.tentackle.log.Logger;
import org.tentackle.pdo.DomainContext;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.session.LoginFailedException;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.Session;
import org.tentackle.session.SessionInfo;

public abstract class DesktopApplication<C extends FxController>
extends AbstractClientApplication {
    private static final Logger LOGGER = Logger.get(DesktopApplication.class);
    private FxApplication fxApplication;
    private C mainController;
    private LoginFailedHandler lfh;
    private Stage mainStage;

    public static DesktopApplication<?> getDesktopApplication() {
        return (DesktopApplication)DesktopApplication.getRunningApplication();
    }

    public DesktopApplication(String name) {
        super(name);
    }

    protected boolean isInteractiveImpl() {
        return true;
    }

    public abstract Class<? extends C> getMainControllerClass();

    public void configureMainStage(Stage mainStage) {
        this.mainStage = mainStage;
    }

    public Stage getMainStage() {
        return this.mainStage;
    }

    public void setMainController(C mainController) {
        this.mainController = mainController;
    }

    public C getMainController() {
        return this.mainController;
    }

    public LoginFailedHandler createLoginFailedHandler(Parent view, SessionInfo sessionInfo) {
        return new LoginFailedHandler(this, view, sessionInfo);
    }

    public void login(final Parent view, final SessionInfo sessionInfo) {
        Service<Void> loginSvc = new Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() throws Exception {
                        try {
                            Session session;
                            if (StringHelper.isAllWhitespace((String)sessionInfo.getUserName())) {
                                DesktopApplication.this.showApplicationStatus(AppFxRdcBundle.getString("PLEASE ENTER THE USERNAME"), 0.0);
                                return null;
                            }
                            DesktopApplication.this.showApplicationStatus(AppFxRdcBundle.getString("CONNECTING TO SERVER..."), 0.05);
                            try {
                                session = DesktopApplication.this.createSession(sessionInfo);
                                session.makeCurrent();
                                DesktopApplication.this.setSessionInfo(sessionInfo);
                                DomainContext context = DesktopApplication.this.createDomainContext(session);
                                if (context == null) {
                                    session.getSessionInfo().clearPassword();
                                    session.close();
                                    return null;
                                }
                                DesktopApplication.this.setDomainContext(context);
                                DesktopApplication.this.updateSessionInfoAfterLogin();
                            }
                            catch (LoginFailedException lfx) {
                                if (DesktopApplication.this.lfh == null) {
                                    DesktopApplication.this.lfh = DesktopApplication.this.createLoginFailedHandler(view, sessionInfo);
                                }
                                DesktopApplication.this.lfh.handle(lfx);
                                return null;
                            }
                            catch (RuntimeException rex) {
                                LOGGER.severe("login failed", (Throwable)rex);
                                Platform.runLater(() -> {
                                    Fx.error((String)AppFxRdcBundle.getString("LOGIN FAILED!"), (Throwable)rex);
                                    view.getScene().getWindow().hide();
                                });
                                return null;
                            }
                            DesktopApplication.this.showApplicationStatus(AppFxRdcBundle.getString("CONFIGURE APPLICATION..."), 0.1);
                            try {
                                DesktopApplication.this.configure();
                            }
                            catch (RuntimeException ex) {
                                LOGGER.severe("configure application failed", (Throwable)ex);
                                return null;
                            }
                            DesktopApplication.this.showApplicationStatus(AppFxRdcBundle.getString("LOADING GUI..."), 0.5);
                            FxController mainCtrlr = Fx.load(DesktopApplication.this.getMainControllerClass());
                            DesktopApplication.this.showApplicationStatus(AppFxRdcBundle.getString("LAUNCH MAIN WINDOW..."), 1.0);
                            Platform.runLater(() -> {
                                try {
                                    session.makeCurrent();
                                    DesktopApplication.this.setMainController(mainCtrlr);
                                    Stage stage = Fx.createStage((Modality)Modality.NONE);
                                    DesktopApplication.this.configureMainStage(stage);
                                    Scene scene = new Scene(mainCtrlr.getView());
                                    stage.setScene(scene);
                                    stage.addEventHandler(WindowEvent.WINDOW_SHOWN, e -> {
                                        try {
                                            DesktopApplication.this.finishStartup();
                                            view.getScene().getWindow().hide();
                                        }
                                        catch (RuntimeException ex) {
                                            LOGGER.severe("finish startup failed", (Throwable)ex);
                                        }
                                    });
                                    stage.show();
                                    Platform.runLater(() -> FxFactory.getInstance().preloadControllers());
                                }
                                catch (RuntimeException rex) {
                                    String msg = MessageFormat.format(AppFxRdcBundle.getString("LAUNCHING {0} FAILED"), ReflectionHelper.getClassBaseName(DesktopApplication.this.getMainControllerClass()));
                                    LOGGER.severe(msg, (Throwable)rex);
                                    Fx.error((String)msg, (Throwable)rex);
                                    view.getScene().getWindow().hide();
                                }
                            });
                        }
                        catch (RuntimeException rex) {
                            LOGGER.severe("login task failed", (Throwable)rex);
                            Platform.runLater(() -> {
                                Fx.error((String)rex.getLocalizedMessage(), (Throwable)rex);
                                Platform.exit();
                            });
                        }
                        return null;
                    }
                };
            }
        };
        loginSvc.start();
    }

    public FxApplication getFxApplication() {
        return this.fxApplication;
    }

    public void setFxApplication(FxApplication fxApplication) {
        this.fxApplication = fxApplication;
    }

    public Class<? extends FxApplication> getApplicationClass() {
        return LoginApplication.class;
    }

    public void showApplicationStatus(String msg, double progress) {
        if (this.fxApplication != null) {
            Platform.runLater(() -> this.fxApplication.showApplicationStatus(msg, progress));
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            LOGGER.info(msg);
        }
    }

    public void registerUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
        Thread.currentThread().setUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return (t, e) -> {
            LOGGER.severe("unhandled exception detected", e);
            Platform.runLater(() -> {
                try {
                    Fx.error((String)e.getLocalizedMessage(), (Throwable)e, (String)AppFxRdcBundle.getString("UNEXPECTED EXCEPTION"));
                }
                catch (Throwable x) {
                    this.stop(99, x);
                }
            });
        };
    }

    public DomainContext createDomainContext(Session session) {
        return super.createDomainContext(null);
    }

    protected void startup() {
        LOGGER.fine("register application");
        this.register();
        LOGGER.fine("initialize application");
        this.initialize();
        LOGGER.fine("initializing FX application");
        Application.launch(this.getApplicationClass(), (String[])this.getCommandLine().getArgs());
    }

    protected void configurePreferences() {
        this.showApplicationStatus(AppFxRdcBundle.getString("INSTALLING PREFERENCES..."), 0.3);
        super.configurePreferences();
    }

    protected void configureSecurityManager() {
        this.showApplicationStatus(AppFxRdcBundle.getString("CONFIGURE SECURITY..."), 0.4);
        super.configureSecurityManager();
    }

    protected void configureModificationTracker() {
        this.showApplicationStatus(AppFxRdcBundle.getString("CONFIGURE MONITORING..."), 0.2);
        super.configureModificationTracker();
        Session trackerSession = this.getSession().clone();
        trackerSession.groupWith(this.getSession().getSessionId());
        ModificationTracker.getInstance().setSession(trackerSession);
    }

    protected void finishStartup() {
        super.finishStartup();
        FxUtilities.getInstance().addStyleSheets();
    }
}

