/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.security;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.tentackle.app.AbstractApplication;
import org.tentackle.bind.Bindable;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.container.FxTab;
import org.tentackle.fx.container.FxTabPane;
import org.tentackle.fx.container.FxVBox;
import org.tentackle.fx.rdc.RdcFactory;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.RdcRuntimeException;
import org.tentackle.fx.rdc.security.SecurityEditor;
import org.tentackle.fx.rdc.table.TablePopup;
import org.tentackle.misc.TrackedList;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.DomainContextProvider;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ReflectionHelper;
import org.tentackle.security.pdo.Security;
import org.tentackle.session.SessionUtilities;
import org.tentackle.validate.ValidationFailedException;

@FxControllerService
public class SecurityRulesView
extends AbstractFxController
implements DomainContextProvider {
    @FXML
    private FxVBox vBox;
    @FXML
    private FxTabPane tabPane;
    @FXML
    private FxTab classTab;
    @FXML
    private FxTab pdoTab;
    @FXML
    private FxTableView<Security> classRulesNode;
    @FXML
    private FxTableView<Security> pdoRulesNode;
    @FXML
    private FxButton moveUpButton;
    @FXML
    private FxButton moveDownButton;
    @FXML
    private FxButton addButton;
    @FXML
    private FxButton removeButton;
    @FXML
    private FxButton saveButton;
    @FXML
    private FxButton cancelButton;
    @Bindable
    private ObservableList<Security> classRules;
    private TrackedList<Security> trackedClassRules;
    @Bindable
    private ObservableList<Security> pdoRules;
    private TrackedList<Security> trackedPdoRules;
    @FXML
    private ResourceBundle resources;
    private DomainContext context;
    private PersistentDomainObject<?> pdo;
    private int classId;
    private Class<?> clazz;
    private SecurityEditor editor;
    private boolean withinSetupSecuredObject;

    public static void show(Class<?> clazz, PersistentDomainObject<?> pdo) {
        Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
        SecurityRulesView controller = (SecurityRulesView)Fx.load(SecurityRulesView.class);
        if (pdo != null) {
            controller.setSecuredObject(pdo);
            stage.setTitle(MessageFormat.format(RdcFxRdcBundle.getString("Security Rules for {0}"), pdo.getPlural()));
        } else {
            controller.setSecuredObject(clazz);
            stage.setTitle(MessageFormat.format(RdcFxRdcBundle.getString("Security Rules for {0}"), ReflectionHelper.getClassBaseName(clazz)));
        }
        Scene scene = new Scene(controller.getView());
        stage.setScene(scene);
        stage.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> controller.cancel(e));
        stage.show();
    }

    public DomainContext getDomainContext() {
        return this.context;
    }

    @FXML
    private void initialize() {
        this.pdoRules = FXCollections.observableArrayList();
        this.classRules = FXCollections.observableArrayList();
        this.editor = (SecurityEditor)Fx.load(SecurityEditor.class);
        this.editor.getContainer().addViewToModelListener(() -> Platform.runLater(() -> {
            this.classRulesNode.refresh();
            this.pdoRulesNode.refresh();
        }));
        this.vBox.getChildren().add((Object)this.editor.getView());
        this.classRulesNode.getSelectionModel().selectedItemProperty().addListener((obs, ov, nv) -> this.setRule((Security)nv));
        this.pdoRulesNode.getSelectionModel().selectedItemProperty().addListener((obs, ov, nv) -> this.setRule((Security)nv));
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((obs, ov, nv) -> {
            if (!this.withinSetupSecuredObject) {
                if (nv == this.classTab) {
                    this.setRule((Security)this.classRulesNode.getSelectionModel().getSelectedItem());
                } else if (nv == this.pdoTab) {
                    this.setRule((Security)this.pdoRulesNode.getSelectionModel().getSelectedItem());
                } else {
                    this.setRule(null);
                }
            }
        });
        this.moveUpButton.setGraphic((Node)Fx.createImageView((String)"up"));
        this.moveUpButton.setOnAction(e -> this.moveUp());
        this.moveDownButton.setGraphic((Node)Fx.createImageView((String)"down"));
        this.moveDownButton.setOnAction(e -> this.moveDown());
        this.addButton.setGraphic((Node)Fx.createImageView((String)"add"));
        this.addButton.setOnAction(e -> this.add());
        this.removeButton.setGraphic((Node)Fx.createImageView((String)"delete"));
        this.removeButton.setOnAction(e -> this.remove());
        this.saveButton.setGraphic((Node)Fx.createImageView((String)"save"));
        this.saveButton.setOnAction(e -> this.save());
        this.cancelButton.setGraphic((Node)Fx.createImageView((String)"cancel"));
        this.cancelButton.setOnAction(e -> this.cancel(null));
    }

    public void configure() {
        TablePopup<Security> classRulesPopup = RdcFactory.getInstance().createTablePopup(this.classRulesNode, "classRules", false, this.resources.getString("Class Rules"));
        classRulesPopup.loadPreferences();
        this.classRulesNode.setSortable(false);
        TablePopup<Security> pdoRulesPopup = RdcFactory.getInstance().createTablePopup(this.pdoRulesNode, "pdoRules", false, this.resources.getString("Object Rules"));
        pdoRulesPopup.loadPreferences();
        this.pdoRulesNode.setSortable(false);
    }

    public void setSecuredObject(PersistentDomainObject<?> pdo) {
        this.pdo = pdo;
        this.classId = pdo.getClassId();
        if (this.classId == 0) {
            throw new RdcRuntimeException(pdo.toGenericString() + " does not provide a class-ID");
        }
        this.clazz = null;
        this.setupSecuredObject();
    }

    public void setSecuredObject(int classId) {
        if (classId == 0) {
            throw new RdcRuntimeException("classId must be > 0");
        }
        this.classId = classId;
        this.clazz = null;
        this.pdo = Pdo.create((String)SessionUtilities.getInstance().getClassName(classId), (DomainContext)AbstractApplication.getRunningApplication().getDomainContext());
        this.setupSecuredObject();
    }

    public void setSecuredObject(Class<?> clazz) {
        if (PersistentDomainObject.class.isAssignableFrom(clazz)) {
            throw new RdcRuntimeException(clazz + " is a persistent domain object");
        }
        this.clazz = clazz;
        this.pdo = null;
        this.classId = 0;
        this.setupSecuredObject();
    }

    private void setupSecuredObject() {
        this.withinSetupSecuredObject = true;
        if (this.pdo != null) {
            this.context = this.pdo.getDomainContext();
            this.trackedClassRules = ((Security)this.on(Security.class)).selectByObject(this.classId, 0L);
            this.classRules.setAll(this.trackedClassRules);
            this.classTab.setText(MessageFormat.format(RdcFxRdcBundle.getString("Rules for all {0}"), this.pdo.getPlural()));
            if (this.pdo.isNew()) {
                this.trackedPdoRules = null;
                this.pdoRules.clear();
                this.tabPane.getSelectionModel().select((Object)this.classTab);
                this.tabPane.getTabs().remove((Object)this.pdoTab);
            } else {
                this.trackedPdoRules = ((Security)this.on(Security.class)).selectByObject(this.classId, this.pdo.getId());
                this.pdoRules.setAll(this.trackedPdoRules);
                this.tabPane.getSelectionModel().select((Object)this.pdoTab);
                this.pdoTab.setText(MessageFormat.format(RdcFxRdcBundle.getString("Rules for {0} {1}"), this.pdo.getSingular(), this.pdo.toString()));
                if (!this.tabPane.getTabs().contains((Object)this.pdoTab)) {
                    this.tabPane.getTabs().add((Object)this.pdoTab);
                }
            }
            this.editor.setSecurableClass(this.pdo.getEffectiveClass());
        } else {
            this.context = AbstractApplication.getRunningApplication().getDomainContext();
            if (this.clazz != null) {
                this.trackedClassRules = ((Security)this.on(Security.class)).selectByObjectClass(this.clazz.getName());
                this.classRules.setAll(this.trackedClassRules);
                this.classTab.setText(MessageFormat.format(RdcFxRdcBundle.getString("Rules for {0}"), ReflectionHelper.getClassBaseName(this.clazz)));
            } else {
                this.classRules.clear();
                this.trackedClassRules = null;
                this.classTab.setText("");
            }
            this.pdoRules.clear();
            this.trackedPdoRules = null;
            this.tabPane.getTabs().remove((Object)this.pdoTab);
            this.tabPane.getSelectionModel().select((Object)this.classTab);
            this.editor.setSecurableClass(this.clazz);
        }
        this.classRulesNode.getSelectionModel().clearSelection();
        this.pdoRulesNode.getSelectionModel().clearSelection();
        this.setRule(null);
        this.getContainer().updateView();
        this.withinSetupSecuredObject = false;
    }

    private void setRule(Security rule) {
        if (rule == null) {
            this.editor.setPdo((Security)this.on(Security.class));
            this.editor.setChangeable(false);
            this.moveUpButton.setDisable(true);
            this.moveDownButton.setDisable(true);
            this.removeButton.setDisable(true);
        } else {
            int size;
            this.editor.setPdo(rule);
            this.editor.setChangeable(true);
            int index = this.trackedClassRules.indexOf((Object)rule);
            if (index >= 0) {
                size = this.trackedClassRules.size();
            } else {
                index = this.trackedPdoRules.indexOf((Object)rule);
                size = this.trackedPdoRules.size();
            }
            this.updateMoveButtons(index, size);
            this.removeButton.setDisable(false);
        }
    }

    private void updateMoveButtons(int index, int size) {
        this.moveUpButton.setDisable(index <= 0);
        this.moveDownButton.setDisable(index >= size - 1);
    }

    private void moveUp() {
        Security rule = this.editor.getPdo();
        int index = this.trackedClassRules.indexOf((Object)rule);
        if (index >= 0) {
            this.trackedClassRules.remove(index);
            this.trackedClassRules.add(index - 1, (Object)rule);
            this.classRules.remove(index);
            this.classRules.add(index - 1, (Object)rule);
            this.classRulesNode.getSelectionModel().select(index - 1);
        } else {
            this.trackedPdoRules.remove(index);
            this.trackedPdoRules.add(index - 1, (Object)rule);
            this.pdoRules.remove(index);
            this.pdoRules.add(index - 1, (Object)rule);
            this.pdoRulesNode.getSelectionModel().select(index - 1);
        }
    }

    private void moveDown() {
        Security rule = this.editor.getPdo();
        int index = this.trackedClassRules.indexOf((Object)rule);
        if (index >= 0) {
            this.trackedClassRules.remove(index);
            this.trackedClassRules.add(index + 1, (Object)rule);
            this.classRules.remove(index);
            this.classRules.add(index + 1, (Object)rule);
            this.classRulesNode.getSelectionModel().select(index + 1);
        } else {
            this.trackedPdoRules.remove(index);
            this.trackedPdoRules.add(index + 1, (Object)rule);
            this.pdoRules.remove(index);
            this.pdoRules.add(index + 1, (Object)rule);
            this.pdoRulesNode.getSelectionModel().select(index + 1);
        }
    }

    private void add() {
        Security sec = (Security)this.on(Security.class);
        Tab tab = (Tab)this.tabPane.getSelectionModel().getSelectedItem();
        if (tab == this.pdoTab) {
            int ndx = this.pdoRulesNode.getSelectionModel().getSelectedIndex();
            if (ndx == -1) {
                ndx = this.trackedPdoRules.size();
            }
            this.trackedPdoRules.add(ndx, (Object)sec);
            this.pdoRules.add(ndx, (Object)sec);
            this.pdoRulesNode.getSelectionModel().select(ndx);
        } else {
            int ndx = this.classRulesNode.getSelectionModel().getSelectedIndex();
            if (ndx == -1) {
                ndx = this.trackedClassRules.size();
            }
            this.trackedClassRules.add(ndx, (Object)sec);
            this.classRules.add(ndx, (Object)sec);
            this.classRulesNode.getSelectionModel().select(ndx);
        }
    }

    private void remove() {
        Security rule = this.editor.getPdo();
        if (this.trackedClassRules.contains((Object)rule)) {
            this.trackedClassRules.remove((Object)rule);
            this.classRules.remove((Object)rule);
        } else {
            this.trackedPdoRules.remove((Object)rule);
            this.pdoRules.remove((Object)rule);
        }
    }

    private void save() {
        TrackedList trackedClassRulesSnapshot = this.trackedClassRules == null ? null : (TrackedList)this.trackedClassRules.createSnapshot();
        TrackedList trackedPdoRulesSnapshot = this.trackedPdoRules == null ? null : (TrackedList)this.trackedPdoRules.createSnapshot();
        try {
            this.getDomainContext().getSession().transaction(() -> {
                int ndx;
                if (this.trackedClassRules != null) {
                    PdoUtilities.getInstance().deleteCollection(this.trackedClassRules.getRemovedObjects());
                    ndx = 0;
                    for (Security sec : this.trackedClassRules) {
                        sec.setPriority(ndx);
                        if (this.classId != 0) {
                            sec.setObjectClassId(this.classId);
                        } else {
                            sec.setObjectClassName(this.clazz.getName());
                        }
                        ++ndx;
                    }
                    PdoUtilities.getInstance().saveCollection(this.trackedClassRules);
                }
                if (this.trackedPdoRules != null) {
                    PdoUtilities.getInstance().deleteCollection(this.trackedPdoRules.getRemovedObjects());
                    ndx = 0;
                    for (Security sec : this.trackedPdoRules) {
                        sec.setPriority(ndx);
                        sec.setObjectClassId(this.classId);
                        sec.setObjectId(this.pdo.getId());
                        ++ndx;
                    }
                    PdoUtilities.getInstance().saveCollection(this.trackedPdoRules);
                }
                return null;
            });
        }
        catch (ValidationFailedException vx) {
            Fx.info((String)vx.resultsAsMessage());
            if (trackedClassRulesSnapshot != null) {
                this.trackedClassRules.revertToSnapshot((Object)trackedClassRulesSnapshot);
                this.classRules.setAll(this.trackedClassRules);
            }
            if (trackedPdoRulesSnapshot != null) {
                this.trackedPdoRules.revertToSnapshot((Object)trackedPdoRulesSnapshot);
                this.pdoRules.setAll(this.trackedPdoRules);
            }
            return;
        }
        this.getStage().hide();
    }

    private void cancel(Event e) {
        boolean modified = this.trackedClassRules != null && (this.trackedClassRules.isModified() || this.trackedClassRules.isElementModified()) || this.trackedPdoRules != null && (this.trackedPdoRules.isModified() || this.trackedPdoRules.isElementModified());
        Runnable discardIt = () -> {
            this.getStage().hide();
            if (e != null) {
                e.consume();
            }
        };
        if (modified) {
            Fx.yes((String)RdcFxRdcBundle.getString("Rules were modified. Really discard all changes?"), (boolean)false, (Runnable)discardIt);
        } else {
            discardIt.run();
        }
    }
}

