/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.table;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.print.PrinterJob;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.tentackle.bind.Bindable;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.bind.FxTableBinding;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.rdc.FileUtilities;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.table.TablePrinter;
import org.tentackle.fx.rdc.table.TableUtilitiesHolder;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.pdo.PdoMember;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistentDomainObject;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Service(value=TableUtilities.class)
public class TableUtilities {
    private static final String SPREADSHEET_EXTENSION = ".csv";
    private static final String LAST_SPREADSHEET_PREFIX = "/_lastSpreadsheetNames_";
    private static final String SPREADSHEET_KEY = "path";
    private static final String XML_EXTENSION = ".xml";
    private static final String LAST_XML_PREFIX = "/_lastXmlNames_";
    private static final String XML_KEY = "path";

    public static TableUtilities getInstance() {
        return TableUtilitiesHolder.INSTANCE;
    }

    public <T extends PersistentDomainObject<T>> TableConfiguration<T> createTableConfiguration(Class<T> pdoClass, ResourceBundle bundle) {
        TableConfiguration config = FxFactory.getInstance().createTableConfiguration(pdoClass, null);
        for (PdoMember member : PdoUtilities.getInstance().getAttributes(config.getObjectClass(), true)) {
            Bindable bindable = member.getGetter().getAnnotation(Bindable.class);
            if (bindable == null) continue;
            String displayName = bundle != null ? bundle.getString(member.getName()) : StringHelper.firstToUpper((String)member.getName());
            config.addColumn(member.getName(), displayName);
        }
        if (config.getColumnConfigurations().isEmpty()) {
            config.addColumn("id", "id");
            config.addColumn("serial", "serial");
        }
        return config;
    }

    public File selectSpreadsheetFile(String tableName, Stage owner) {
        return FileUtilities.getInstance().selectFile(StringHelper.trimRight((String)(LAST_SPREADSHEET_PREFIX + tableName), (char)'/'), "path", SPREADSHEET_EXTENSION, RdcFxRdcBundle.getString("SPREADSHEET FILE"), owner);
    }

    public File selectXmlFile(String tableName, Stage owner) {
        return FileUtilities.getInstance().selectFile(StringHelper.trimRight((String)(LAST_XML_PREFIX + tableName), (char)'/'), "path", XML_EXTENSION, RdcFxRdcBundle.getString("XML FILE"), owner);
    }

    public <S> void toSpreadsheet(FxTableView<S> table, File file, boolean onlySelected) {
        try (PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));){
            int ndx = 0;
            for (TableColumnConfiguration tc : table.getConfiguration().getColumnConfigurations()) {
                if (ndx > 0) {
                    out.append(',');
                }
                out.append(this.toCSV(tc.getDisplayedName()));
                ++ndx;
            }
            out.append('\n');
            ObservableList items = onlySelected ? table.getSelectionModel().getSelectedItems() : table.getItems();
            for (Object item : items) {
                ndx = 0;
                for (TableColumnConfiguration tc : table.getConfiguration().getColumnConfigurations()) {
                    FxTableBinding binding;
                    if (ndx > 0) {
                        out.append(',');
                    }
                    if ((binding = tc.getBinding()) != null) {
                        binding.setBoundRootObject(item);
                        Object value = binding.getModelValue();
                        if (value != null) {
                            out.append(this.toCSV(value.toString()));
                        }
                    }
                    ++ndx;
                }
                out.append('\n');
            }
        }
        catch (IOException ex) {
            throw new FxRuntimeException("creating spreadsheet file failed", (Throwable)ex);
        }
    }

    public <S> void toXml(FxTableView<S> table, File file, boolean onlySelected) {
        try (PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));){
            StreamResult streamResult = new StreamResult(out);
            SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            TransformerHandler hd = tf.newTransformerHandler();
            Transformer serializer = hd.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            hd.setResult(streamResult);
            hd.startDocument();
            AttributesImpl atts = new AttributesImpl();
            hd.startElement("", "", "Table", atts);
            ObservableList items = onlySelected ? table.getSelectionModel().getSelectedItems() : table.getItems();
            for (Object item : items) {
                hd.startElement("", "", table.getConfiguration().getName(), atts);
                for (TableColumnConfiguration tc : table.getConfiguration().getColumnConfigurations()) {
                    String tag = tc.getName();
                    FxTableBinding binding = tc.getBinding();
                    if (binding == null) continue;
                    binding.setBoundRootObject(item);
                    Object value = binding.getModelValue();
                    String text = value == null ? "" : value.toString();
                    hd.startElement("", "", tag, atts);
                    hd.characters(text.toCharArray(), 0, text.length());
                    hd.endElement("", "", tag);
                }
                hd.endElement("", "", table.getConfiguration().getName());
            }
            hd.endElement("", "", "Table");
            hd.endDocument();
        }
        catch (IOException | TransformerConfigurationException | SAXException ex) {
            throw new FxRuntimeException("creating XML file failed", (Throwable)ex);
        }
    }

    public void print(FxTableView<?> table, String title) {
        PrinterJob job = PrinterJob.createPrinterJob();
        if (job != null && job.showPrintDialog((Window)Fx.getStage(table))) {
            TablePrinter.print(table, title, job);
        }
    }

    private String toCSV(String value) {
        if (value != null) {
            StringBuilder field = new StringBuilder();
            field.append('\"');
            int length = value.length();
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                if (c == '\"') {
                    field.append('\"');
                }
                field.append(c);
            }
            field.append('\"');
            return field.toString();
        }
        return null;
    }
}

