/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.app;

import java.text.MessageFormat;
import javafx.application.Platform;
import javafx.scene.Parent;
import org.tentackle.fx.Fx;
import org.tentackle.fx.rdc.app.AppFxRdcBundle;
import org.tentackle.fx.rdc.app.DesktopApplication;
import org.tentackle.fx.rdc.app.LoginApplication;
import org.tentackle.log.Logger;
import org.tentackle.session.AlreadyLoggedInException;
import org.tentackle.session.LoginFailedException;
import org.tentackle.session.SessionInfo;
import org.tentackle.session.VersionInfoIncompatibleException;

public class LoginFailedHandler {
    private static final Logger LOGGER = Logger.get(LoginFailedHandler.class);
    private final DesktopApplication<?> application;
    private final Parent view;
    private final SessionInfo sessionInfo;
    private int loginCount;

    public LoginFailedHandler(DesktopApplication<?> application, Parent view, SessionInfo sessionInfo) {
        this.application = application;
        this.view = view;
        this.sessionInfo = sessionInfo;
    }

    public DesktopApplication<?> getApplication() {
        return this.application;
    }

    public Parent getView() {
        return this.view;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public Runnable handle(Exception ex) {
        LOGGER.severe(ex.getMessage(), (Throwable)ex);
        if (ex instanceof AlreadyLoggedInException) {
            this.application.showApplicationStatus(ex.getLocalizedMessage(), 0.0);
        } else if (ex instanceof VersionInfoIncompatibleException) {
            VersionInfoIncompatibleException vx = (VersionInfoIncompatibleException)ex;
            Platform.runLater(() -> {
                Fx.info((String)MessageFormat.format(AppFxRdcBundle.getString("client version {0} does not match server version {1}"), vx.getClientVersion(), vx.getServerVersion()));
                this.view.getScene().getWindow().hide();
            });
        } else if (ex instanceof LoginFailedException) {
            this.loginCount = LoginApplication.isAutoLogin(this.sessionInfo) ? 3 : ++this.loginCount;
            switch (this.loginCount) {
                case 1: {
                    this.application.showApplicationStatus(AppFxRdcBundle.getString("LOGIN FAILED! (2 MORE RETRIES)"), 0.0);
                    break;
                }
                case 2: {
                    this.application.showApplicationStatus(AppFxRdcBundle.getString("LOGIN FAILED! (LAST RETRY)"), 0.0);
                    break;
                }
                default: {
                    this.application.showApplicationStatus(AppFxRdcBundle.getString("LOGIN FAILED!"), 0.0);
                    Platform.runLater(() -> {
                        Fx.info((String)AppFxRdcBundle.getString("LOGIN REFUSED! PLEASE CHECK YOUR USERNAME AND PASSWORD"));
                        this.view.getScene().getWindow().hide();
                    });
                    break;
                }
            }
        } else {
            LOGGER.severe("login failed", (Throwable)ex);
            Platform.runLater(() -> {
                Fx.error((String)AppFxRdcBundle.getString("LOGIN FAILED!"), (Throwable)ex);
                this.view.getScene().getWindow().hide();
            });
        }
        return null;
    }
}

