/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.component.delegate;

import java.util.function.Supplier;
import javafx.collections.ObservableList;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.rdc.translate.PdoComponentAddon;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;

public class RdcBoxDelegateImpl {
    private final FxComponent component;
    private final Supplier<ObservableList> itemSupplier;
    private final Supplier<PdoComponentAddon> pdoAddonSupplier;
    private boolean loadPdosPending;

    public RdcBoxDelegateImpl(FxComponent component, Supplier<ObservableList> itemSupplier, Supplier<PdoComponentAddon> pdoAddonSupplier) {
        this.component = component;
        this.itemSupplier = itemSupplier;
        this.pdoAddonSupplier = pdoAddonSupplier;
    }

    public void prepareSetType(Class<?> type) {
        if (PersistentDomainObject.class.isAssignableFrom(type)) {
            this.loadPdosPending = true;
        }
    }

    public void prepareSetViewValue() {
        if (this.loadPdosPending) {
            this.loadPdosPending = false;
            FxComponentBinding binding = this.component.getBinding();
            DomainContext context = (DomainContext)binding.getBinder().getBindingProperty(DomainContext.class);
            if (context != null) {
                PersistentDomainObject pdo = Pdo.create((Class)this.component.getType(), (DomainContext)context);
                ObservableList items = this.itemSupplier.get();
                items.clear();
                items.addAll(this.pdoAddonSupplier.get().selectAll(pdo));
            }
        }
    }
}

