/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import org.tentackle.common.Service;
import org.tentackle.fx.Fx;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.fx.rdc.PdoEditor;
import org.tentackle.fx.rdc.PdoFinder;
import org.tentackle.fx.rdc.PdoTableCell;
import org.tentackle.fx.rdc.PdoTreeCell;
import org.tentackle.fx.rdc.RdcFactory;
import org.tentackle.fx.rdc.crud.PdoCrud;
import org.tentackle.fx.rdc.search.PdoSearch;
import org.tentackle.fx.rdc.table.TablePopup;
import org.tentackle.pdo.PersistentDomainObject;

@Service(value=RdcFactory.class)
public class DefaultRdcFactory
implements RdcFactory {
    @Override
    public <T extends PersistentDomainObject<T>> PdoCrud<T> createPdoCrud(T pdo, boolean editable, boolean modal) {
        GuiProvider<T> provider = GuiProviderFactory.getInstance().createGuiProvider(pdo);
        PdoEditor<T> editor = provider.createEditor();
        PdoCrud crud = (PdoCrud)Fx.load(PdoCrud.class);
        crud.setEditable(editable);
        crud.setEditor(editor);
        crud.setModal(modal);
        crud.setPdo(pdo);
        return crud;
    }

    @Override
    public <T extends PersistentDomainObject<T>> PdoSearch<T> createPdoSearch(T pdo) {
        GuiProvider<T> provider = GuiProviderFactory.getInstance().createGuiProvider(pdo);
        PdoFinder<T> finder = provider.createFinder();
        PdoSearch search = (PdoSearch)Fx.load(PdoSearch.class);
        search.setFinder(finder);
        search.setPdo(pdo);
        return search;
    }

    @Override
    public <T extends PersistentDomainObject<T>> PdoTreeCell<T> createTreeCell() {
        return new PdoTreeCell();
    }

    @Override
    public <S, T extends PersistentDomainObject<T>> PdoTableCell<S, T> createTableCell() {
        return new PdoTableCell();
    }

    @Override
    public <S> TablePopup<S> createTablePopup(FxTableView<S> table, String preferencesSuffix, boolean noViewSize, String title) {
        return new TablePopup<S>(table, preferencesSuffix, noViewSize, title);
    }
}

