/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.translate;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.RdcUtilities;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;

public class PdoComponentAddon<T extends PersistentDomainObject<T>> {
    private static final String PDO_STYLE = "tt-pdo-style";
    private final FxComponent component;
    private final Supplier<T> pdoSupplier;
    private boolean inSearchOrEdit;
    private T pdo;

    public PdoComponentAddon(FxComponent component, Supplier<T> pdoSupplier) {
        this.component = component;
        this.pdoSupplier = pdoSupplier;
        Control control = (Control)component;
        control.addEventFilter(KeyEvent.ANY, event -> {
            if (!(event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShiftDown() || event.isShortcutDown())) {
                if (event.getCode() == KeyCode.F2) {
                    event.consume();
                    if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                        Platform.runLater(this::edit);
                    }
                } else if (event.getCode() == KeyCode.F3) {
                    event.consume();
                    if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                        Platform.runLater(this::search);
                    }
                }
            }
        });
        if (!control.getStyleClass().contains((Object)PDO_STYLE)) {
            control.getStyleClass().add((Object)PDO_STYLE);
            ContextMenu menu = control.getContextMenu();
            if (menu == null) {
                menu = new ContextMenu();
                control.setContextMenu(menu);
            } else {
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
            MenuItem editItem = new MenuItem(RdcFxRdcBundle.getString("EDIT"));
            editItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F2, new KeyCombination.Modifier[0]));
            editItem.setOnAction(event -> this.edit());
            menu.setOnShowing(event -> editItem.setDisable(pdoSupplier.get() == null));
            MenuItem searchItem = new MenuItem(RdcFxRdcBundle.getString("SEARCH"));
            searchItem.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.F3, new KeyCombination.Modifier[0]));
            searchItem.setOnAction(event -> this.search());
            menu.getItems().addAll((Object[])new MenuItem[]{editItem, searchItem});
        }
    }

    public T getPdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.pdo = pdo;
    }

    public boolean isInSearchOrEdit() {
        return this.inSearchOrEdit;
    }

    public void edit() {
        if (!this.inSearchOrEdit) {
            this.pdo = (PersistentDomainObject)this.pdoSupplier.get();
            if (this.pdo != null) {
                this.inSearchOrEdit = true;
                ObservableList pdoList = FXCollections.observableArrayList();
                pdoList.add(this.pdo);
                RdcUtilities.getInstance().displayCrudStage(this.pdo, pdoList, !this.pdo.isImmutable(), Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)((Node)this.component)), p -> {
                    this.pdo = p;
                    this.inSearchOrEdit = false;
                }, null);
            }
        }
    }

    public void search() {
        if (!this.inSearchOrEdit) {
            this.inSearchOrEdit = true;
            this.searchPdo(this.createPdo(), found -> {
                if (found != null && this.component.isChangeable()) {
                    this.pdo = found;
                    this.component.setViewValue(this.pdo);
                    this.component.updateModel();
                }
                this.inSearchOrEdit = false;
            });
        }
    }

    public T createPdo() {
        Class pdoClass = this.component.getType();
        DomainContext context = this.component.getParentContainer() != null ? (DomainContext)this.component.getBinding().getBinder().getBindingProperty(DomainContext.class) : (this.component.getTableCell() != null ? (DomainContext)this.component.getTableCell().getColumnConfiguration().getTableConfiguration().getBinder().getBindingProperty(DomainContext.class) : (DomainContext)((Node)this.component).getProperties().get(DomainContext.class));
        if (context == null) {
            throw new FxRuntimeException("missing binding property for DomainContext");
        }
        return (T)Pdo.create((Class)pdoClass, (DomainContext)context);
    }

    public void searchPdo(T proxy, Consumer<T> selectedItem) {
        RdcUtilities.getInstance().displaySearchStage(proxy, Modality.APPLICATION_MODAL, (Window)Fx.getStage((Node)((Node)this.component)), true, list -> selectedItem.accept(list.isEmpty() ? null : (PersistentDomainObject)list.get(0)));
    }

    public List<T> selectAll(T proxy) {
        return proxy.selectAllCached();
    }
}

