/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import org.tentackle.bind.Bindable;
import org.tentackle.bind.BindableElement;
import org.tentackle.bind.Binding;
import org.tentackle.bind.BindingMember;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.bind.FxBindingFactory;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.component.FxTextArea;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.rdc.PdoEditor;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoCache;
import org.tentackle.pdo.PdoMember;
import org.tentackle.pdo.PdoUtilities;
import org.tentackle.pdo.PersistentDomainObject;

public class DefaultPdoEditor<T extends PersistentDomainObject<T>>
extends PdoEditor<T> {
    private final Class<T> pdoClass;
    private final ResourceBundle bundle;
    private final Map<PdoMember, FxComponent> nodeMap;
    private final BindingMember pdoMember;
    private final BindingMember[] parents;
    private T pdo;
    private static final String PDO = "pdo";

    public DefaultPdoEditor(Class<T> pdoClass, ResourceBundle bundle) {
        this.pdoClass = pdoClass;
        this.bundle = bundle;
        BindableElement pdoElement = FxBindingFactory.getInstance().createBindableElement(pdoClass, PDO);
        try {
            Field field = DefaultPdoEditor.class.getDeclaredField(PDO);
            field.setAccessible(true);
            pdoElement.setField(field);
        }
        catch (NoSuchFieldException e) {
            throw new FxRuntimeException("cannot determine parent field", (Throwable)e);
        }
        this.pdoMember = FxBindingFactory.getInstance().createBindingMember(DefaultPdoEditor.class, null, PDO, PDO, pdoElement);
        this.parents = new BindingMember[]{this.pdoMember};
        this.nodeMap = this.createNodeMap();
        this.setView(this.createView(this.nodeMap));
    }

    public Class<T> getPdoClass() {
        return this.pdoClass;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    @Override
    public void requestInitialFocus() {
        FxComponent node = this.getFirstFocusableNode(this.nodeMap);
        if (node instanceof Node) {
            Platform.runLater(() -> ((Node)((Node)node)).requestFocus());
        }
    }

    @Override
    public T getPdo() {
        return this.pdo;
    }

    @Override
    public void setPdo(T pdo) {
        this.pdo = pdo;
        this.getBinder().putBindingProperty(DomainContext.class, (Object)pdo.getDomainContext());
    }

    @Override
    public String getValidationPath() {
        return PDO;
    }

    protected FxComponent getFirstFocusableNode(Map<PdoMember, FxComponent> nodes) {
        FxComponent node = null;
        for (Map.Entry<PdoMember, FxComponent> entry : nodes.entrySet()) {
            if (!entry.getKey().isDomainKey() || !entry.getValue().isChangeable()) continue;
            node = entry.getValue();
            break;
        }
        if (node == null) {
            for (FxComponent comp : nodes.values()) {
                if (!comp.isChangeable()) continue;
                node = comp;
                break;
            }
        }
        return node;
    }

    protected FxComponent createNode(PdoMember attribute) {
        FxComponent node = null;
        Bindable bindable = attribute.getGetter().getAnnotation(Bindable.class);
        if (bindable != null) {
            int ndx;
            PersistentDomainObject object;
            PdoCache cache;
            String bindingOptions = bindable.options();
            Class<?> type = attribute.getGetter().getReturnType();
            node = PersistentDomainObject.class.isAssignableFrom(type) ? ((cache = (object = Pdo.create(type)).getCache()) != null && cache.isPreloading() ? (FxComponent)Fx.createNode(ComboBox.class) : (FxComponent)Fx.createNode(TextField.class)) : (Boolean.class.equals(type) || Boolean.TYPE.equals(type) ? (FxComponent)Fx.createNode(CheckBox.class) : (Enum.class.isAssignableFrom(type) ? (FxComponent)Fx.createNode(ChoiceBox.class) : ((ndx = bindingOptions.indexOf("LINES=")) >= 0 ? (FxComponent)Fx.createNode(TextArea.class) : (FxComponent)Fx.createNode(TextField.class))));
            this.bind(this.pdoMember, attribute, node, bindingOptions);
        }
        return node;
    }

    protected void bind(BindingMember parent, PdoMember attribute, FxComponent node, String bindingOptions) {
        BindableElement element = FxBindingFactory.getInstance().createBindableElement(attribute.getGetter().getReturnType(), PDO + StringHelper.firstToUpper((String)attribute.getName()));
        element.setGetter(attribute.getGetter());
        element.setSetter(attribute.getSetter());
        BindingMember member = FxBindingFactory.getInstance().createBindingMember(this.pdoClass, parent, attribute.getName(), "pdo." + attribute.getName(), element);
        FxComponentBinding binding = FxBindingFactory.getInstance().createComponentBinding(this.getBinder(), this.parents, member, node, bindingOptions);
        this.getBinder().addBinding((Binding)binding);
        node.setBindingPath(member.getMemberPath());
        node.setComponentPath(this.getClass().getName() + "." + attribute.getName() + "Node");
        if (FxUtilities.getInstance().getBindingOption(bindingOptions, "COLS") == null) {
            if (node instanceof FxTextField) {
                FxTextField textField = (FxTextField)node;
                if (textField.getMaxColumns() > 0) {
                    textField.setColumns(textField.getMaxColumns());
                }
            } else if (node instanceof FxTextArea) {
                FxTextArea textArea = (FxTextArea)node;
                textArea.setColumns(FxUtilities.getInstance().getDefaultTextAreaColumns(textArea));
            }
        }
    }

    protected Map<PdoMember, FxComponent> createNodeMap() {
        LinkedHashMap<PdoMember, FxComponent> map = new LinkedHashMap<PdoMember, FxComponent>();
        PdoUtilities.getInstance().getAttributes(this.getPdoClass(), true).forEach(attr -> {
            FxComponent node = this.createNode((PdoMember)attr);
            if (node != null) {
                map.put((PdoMember)attr, node);
            }
        });
        if (map.isEmpty()) {
            throw new FxRuntimeException("no visible attributes found for " + this.getPdoClass().getName());
        }
        return map;
    }

    protected Parent createView(Map<PdoMember, FxComponent> nodes) {
        GridPane grid = (GridPane)Fx.createNode(GridPane.class);
        grid.setVgap(5.0);
        grid.setHgap(5.0);
        int row = 0;
        for (Map.Entry<PdoMember, FxComponent> entry : nodes.entrySet()) {
            Label label = this.createLabel(entry.getKey());
            grid.add((Node)label, 0, row);
            GridPane.setHalignment((Node)label, (HPos)HPos.RIGHT);
            Node node = (Node)entry.getValue();
            grid.add(node, 1, row);
            GridPane.setHalignment((Node)node, (HPos)HPos.LEFT);
            GridPane.setFillWidth((Node)node, (Boolean)false);
            ++row;
        }
        return grid;
    }

    protected Label createLabel(PdoMember attribute) {
        Object text = this.getBundle() != null ? this.getBundle().getString(attribute.getName()) : attribute.getComment();
        if (!((String)text).endsWith(":")) {
            text = (String)text + ":";
        }
        Label label = (Label)Fx.createNode(Label.class);
        label.setText((String)text);
        return label;
    }
}

