/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.security;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.stage.Window;
import org.tentackle.bind.Bindable;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxCheckBox;
import org.tentackle.fx.component.FxRadioButton;
import org.tentackle.fx.component.FxTextArea;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.container.FxGridPane;
import org.tentackle.fx.rdc.PdoEditor;
import org.tentackle.fx.rdc.security.SecurityDialogFactory;
import org.tentackle.pdo.DomainContext;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.pdo.Security;

@FxControllerService
public class SecurityEditor
extends PdoEditor<Security> {
    private static final String DENY_STYLE = "sec-deny";
    private static final String ALLOW_STYLE = "sec-allow";
    private static final String NA_STYLE = "sec-na";
    @Bindable
    private Security sec;
    @FXML
    private FxTextField secGranteeField;
    @FXML
    private FxButton granteeButton;
    @FXML
    private FxTextField secDomainContextObjectField;
    @FXML
    private FxButton contextButton;
    @FXML
    private FxRadioButton allowButton;
    @FXML
    private FxRadioButton denyButton;
    @FXML
    private FxGridPane permissionPane;
    @FXML
    private FxTextArea secMessageField;
    private Class<?> clazz;
    private Map<Permission, FxCheckBox> permissionCheckBoxes;
    private Map<Permission, FxRadioButton> permissionRadioButtons;

    @FXML
    private void initialize() {
        this.secGranteeField.setChangeable(false);
        this.granteeButton.setOnAction(e -> this.selectGrantee());
        this.allowButton.setBindable(false);
        this.denyButton.setBindable(false);
        ToggleGroup group = new ToggleGroup();
        this.allowButton.setToggleGroup(group);
        this.allowButton.getStyleClass().add((Object)ALLOW_STYLE);
        this.denyButton.setToggleGroup(group);
        this.denyButton.getStyleClass().add((Object)DENY_STYLE);
        group.selectedToggleProperty().addListener(obs -> {
            if (group.getSelectedToggle() == this.allowButton) {
                this.sec.setAllowed(true);
            } else if (group.getSelectedToggle() == this.denyButton) {
                this.sec.setAllowed(false);
            }
            this.updateEffectivePermissions();
        });
        this.permissionCheckBoxes = new TreeMap<Permission, FxCheckBox>();
        this.permissionRadioButtons = new HashMap<Permission, FxRadioButton>();
        for (Class permissionIf : SecurityFactory.getInstance().getPermissionInterfaces()) {
            Permission permission = SecurityFactory.getInstance().getPermission(permissionIf);
            FxCheckBox checkBox = (FxCheckBox)Fx.createNode(CheckBox.class);
            checkBox.setText(permission.getName());
            checkBox.setBindable(false);
            checkBox.addViewToModelListener(() -> {
                this.permissionsToModel();
                this.updateEffectivePermissions();
            });
            this.permissionCheckBoxes.put(permission, checkBox);
            FxRadioButton effectiveRadioButton = (FxRadioButton)Fx.createNode(RadioButton.class);
            effectiveRadioButton.setBindable(false);
            effectiveRadioButton.setChangeable(false);
            this.permissionRadioButtons.put(permission, effectiveRadioButton);
        }
        int row = 1;
        for (Map.Entry<Permission, FxCheckBox> entry : this.permissionCheckBoxes.entrySet()) {
            this.permissionPane.add((Node)entry.getValue(), 0, row);
            this.permissionPane.add((Node)this.permissionRadioButtons.get(entry.getKey()), 1, row);
            ++row;
        }
        if (!SecurityDialogFactory.getInstance().isDomainContextUsed()) {
            this.contextButton.setDisable(true);
            this.secDomainContextObjectField.setDisable(true);
        } else {
            this.contextButton.setOnAction(e -> this.selectContext());
        }
    }

    @Override
    public Security getPdo() {
        return this.sec;
    }

    @Override
    public void setPdo(Security pdo) {
        Class[] permissions;
        this.sec = pdo;
        this.getBinder().putBindingProperty(DomainContext.class, (Object)pdo.getDomainContext());
        if (pdo.isAllowed()) {
            this.allowButton.setSelected(true);
        } else {
            this.denyButton.setSelected(true);
        }
        for (FxCheckBox checkBox : this.permissionCheckBoxes.values()) {
            checkBox.setSelected(false);
        }
        for (Class permission : permissions = SecurityFactory.getInstance().stringToPermissionInterfaces(pdo.getPermissions())) {
            FxCheckBox box = this.permissionCheckBoxes.get(SecurityFactory.getInstance().getPermission(permission));
            if (box == null) continue;
            box.setSelected(true);
        }
        this.getContainer().updateView();
        this.updateEffectivePermissions();
    }

    public void setSecurableClass(Class<?> clazz) {
        this.clazz = clazz;
        for (Map.Entry<Permission, FxCheckBox> entry : this.permissionCheckBoxes.entrySet()) {
            Permission permission = entry.getKey();
            FxCheckBox box = entry.getValue();
            boolean changeable = permission.appliesTo(clazz);
            box.setChangeable(changeable);
            if (changeable) {
                box.getStyleClass().remove((Object)NA_STYLE);
                continue;
            }
            if (box.getStyleClass().contains((Object)NA_STYLE)) continue;
            box.getStyleClass().add((Object)NA_STYLE);
        }
    }

    @Override
    public void requestInitialFocus() {
        this.allowButton.requestFocus();
    }

    @Override
    public void setChangeable(boolean changeable) {
        super.setChangeable(changeable);
        this.granteeButton.setDisable(!changeable);
    }

    private void selectGrantee() {
        SecurityDialogFactory.getInstance().selectGrantee((Window)this.getStage(), this.getDomainContext(), grantee -> {
            this.sec.setGrantee(grantee);
            this.secGranteeField.updateView();
            this.getContainer().getDelegate().fireViewToModelListeners();
        });
    }

    private void selectContext() {
        SecurityDialogFactory.getInstance().selectDomainContextObject((Window)this.getStage(), this.getDomainContext(), contextPdo -> {
            this.sec.setDomainContextObject(contextPdo);
            this.secDomainContextObjectField.updateView();
            this.getContainer().getDelegate().fireViewToModelListeners();
        });
    }

    private void updateEffectivePermissions() {
        Class[] permissions = SecurityFactory.getInstance().stringToPermissionInterfaces(this.sec.getPermissions());
        for (Map.Entry<Permission, FxRadioButton> entry : this.permissionRadioButtons.entrySet()) {
            Permission permission = entry.getKey();
            FxRadioButton effectiveRadioButton = entry.getValue();
            if (this.sec.isAllowed()) {
                if (!effectiveRadioButton.getStyleClass().contains((Object)ALLOW_STYLE)) {
                    effectiveRadioButton.getStyleClass().add((Object)ALLOW_STYLE);
                }
                effectiveRadioButton.getStyleClass().remove((Object)DENY_STYLE);
                effectiveRadioButton.setSelected(permissions != null && permission.appliesTo(this.clazz) && permission.isAllowedBy(permissions));
                continue;
            }
            if (!effectiveRadioButton.getStyleClass().contains((Object)DENY_STYLE)) {
                effectiveRadioButton.getStyleClass().add((Object)DENY_STYLE);
            }
            effectiveRadioButton.getStyleClass().remove((Object)ALLOW_STYLE);
            effectiveRadioButton.setSelected(permissions != null && permission.appliesTo(this.clazz) && permission.isDeniedBy(permissions));
        }
    }

    private void permissionsToModel() {
        LinkedHashSet<Permission> permissions = new LinkedHashSet<Permission>();
        for (Map.Entry<Permission, FxCheckBox> entry : this.permissionCheckBoxes.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            permissions.add(entry.getKey());
        }
        this.sec.setPermissions(permissions.isEmpty() ? null : SecurityFactory.getInstance().permissionsToString(permissions));
    }
}

