/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.table;

import java.io.File;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.rdc.FileUtilities;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.rdc.table.TableUtilities;
import org.tentackle.log.Logger;
import org.tentackle.prefs.PersistedPreferencesFactory;

public class TablePopup<S> {
    private static final Logger LOGGER = Logger.get(TablePopup.class);
    private final FxTableView<S> table;
    private final String preferencesSuffix;
    private String title;
    private boolean columnMenuEnabled = true;

    public TablePopup(FxTableView<S> table, String preferencesSuffix, String title) {
        this.table = table;
        this.preferencesSuffix = preferencesSuffix;
        this.title = title;
        ContextMenu menu = this.createContextMenu();
        table.setContextMenu(menu);
        for (TableColumn column : table.getColumns()) {
            column.setContextMenu(menu);
        }
    }

    public FxTableView<S> getTable() {
        return this.table;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPreferencesSuffix() {
        return this.preferencesSuffix;
    }

    public boolean isColumnMenuEnabled() {
        return this.columnMenuEnabled;
    }

    public void setColumnMenuEnabled(boolean columnMenuEnabled) {
        this.columnMenuEnabled = columnMenuEnabled;
    }

    public ContextMenu createContextMenu() {
        Menu columnMenu;
        ContextMenu menu = new ContextMenu();
        ObservableList columns = this.table.getColumns();
        if (this.columnMenuEnabled) {
            columnMenu = new Menu();
            columnMenu.setText(RdcFxRdcBundle.getString("COLUMNS..."));
            menu.getItems().add((Object)columnMenu);
        } else {
            columnMenu = null;
        }
        MenuItem autoWidthItem = new MenuItem();
        autoWidthItem.setText(RdcFxRdcBundle.getString("AUTO ADJUST"));
        autoWidthItem.setOnAction(e -> this.autoWidth());
        menu.getItems().add((Object)autoWidthItem);
        MenuItem printItem = new MenuItem();
        printItem.setText(RdcFxRdcBundle.getString("PRINT"));
        printItem.setOnAction(e -> this.print());
        menu.getItems().add((Object)printItem);
        MenuItem excelItem = new MenuItem();
        excelItem.setText(RdcFxRdcBundle.getString("EXPORT TO SPREADSHEET"));
        excelItem.setOnAction(e -> this.toSpreadsheet(false));
        menu.getItems().add((Object)excelItem);
        MenuItem selectedExcelItem = new MenuItem();
        selectedExcelItem.setText(RdcFxRdcBundle.getString("EXPORT TO SPREADSHEET (SELECTED)"));
        selectedExcelItem.setOnAction(e -> this.toSpreadsheet(true));
        menu.getItems().add((Object)selectedExcelItem);
        MenuItem xmlItem = new MenuItem();
        xmlItem.setText(RdcFxRdcBundle.getString("EXPORT TO XML"));
        xmlItem.setOnAction(e -> this.toXml(false));
        menu.getItems().add((Object)xmlItem);
        MenuItem selectedXmlItem = new MenuItem();
        selectedXmlItem.setText(RdcFxRdcBundle.getString("EXPORT TO XML (SELECTED)"));
        selectedXmlItem.setOnAction(e -> this.toXml(true));
        menu.getItems().add((Object)selectedXmlItem);
        if (PersistedPreferencesFactory.getInstance().isSystemOnly()) {
            if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                MenuItem saveItem = new MenuItem();
                saveItem.setText(RdcFxRdcBundle.getString("SAVE SYSTEM PREFERENCES"));
                saveItem.setOnAction(e -> this.savePreferences(true));
                menu.getItems().add((Object)saveItem);
            }
            MenuItem restoreItem = new MenuItem();
            restoreItem.setText(RdcFxRdcBundle.getString("LOAD SYSTEM PREFERENCES"));
            restoreItem.setOnAction(e -> this.loadPreferences(true));
            menu.getItems().add((Object)restoreItem);
        } else {
            if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                MenuItem saveItem = new MenuItem();
                saveItem.setText(RdcFxRdcBundle.getString("SAVE USER PREFERENCES"));
                saveItem.setOnAction(e -> this.savePreferences(false));
                menu.getItems().add((Object)saveItem);
            }
            MenuItem restoreItem = new MenuItem();
            restoreItem.setText(RdcFxRdcBundle.getString("LOAD USER PREFERENCES"));
            restoreItem.setOnAction(e -> this.loadPreferences(false));
            menu.getItems().add((Object)restoreItem);
            MenuItem restoreSysItem = new MenuItem();
            restoreSysItem.setText(RdcFxRdcBundle.getString("LOAD SYSTEM PREFERENCES"));
            restoreSysItem.setOnAction(e -> this.loadPreferences(true));
            menu.getItems().add((Object)restoreSysItem);
        }
        menu.setOnShowing(event -> {
            if (columnMenu != null) {
                columnMenu.getItems().clear();
                boolean allVisible = true;
                boolean allInvisible = true;
                for (TableColumn column : columns) {
                    CheckMenuItem item = new CheckMenuItem(column.getText());
                    item.setSelected(column.isVisible());
                    if (column.isVisible()) {
                        allInvisible = false;
                    } else {
                        allVisible = false;
                    }
                    item.setOnAction(e -> column.setVisible(item.isSelected()));
                    columnMenu.getItems().add((Object)item);
                }
                if (!allVisible) {
                    MenuItem showAllItem = new MenuItem(RdcFxRdcBundle.getString("SHOW ALL"));
                    showAllItem.setOnAction(e -> {
                        for (TableColumn column : columns) {
                            column.setVisible(true);
                        }
                    });
                    columnMenu.getItems().add((Object)showAllItem);
                }
                if (!allInvisible) {
                    MenuItem hideAllItem = new MenuItem(RdcFxRdcBundle.getString("HIDE ALL"));
                    hideAllItem.setOnAction(e -> {
                        for (TableColumn column : columns) {
                            column.setVisible(false);
                        }
                    });
                    columnMenu.getItems().add((Object)hideAllItem);
                }
            }
        });
        return menu;
    }

    public void autoWidth() {
        FxUtilities.getInstance().resizeColumnsToFitContent(this.table);
    }

    public void print() {
        TableUtilities.getInstance().print(this.table, this.title);
    }

    public void toSpreadsheet(boolean onlySelected) {
        try {
            File file = TableUtilities.getInstance().selectSpreadsheetFile(this.table.getConfiguration().getName(), Fx.getStage(this.table));
            if (file != null) {
                TableUtilities.getInstance().toSpreadsheet(this.table, file, onlySelected);
                FileUtilities.getInstance().editFile(file);
            }
        }
        catch (RuntimeException ex) {
            LOGGER.severe("creating spreadsheet failed", (Throwable)ex);
            Fx.error((String)RdcFxRdcBundle.getString("COULD NOT CREATE SPREADSHEET FILE"), (Throwable)ex);
        }
    }

    public void toXml(boolean onlySelected) {
        try {
            File file = TableUtilities.getInstance().selectXmlFile(this.table.getConfiguration().getName(), Fx.getStage(this.table));
            if (file != null) {
                TableUtilities.getInstance().toXml(this.table, file, onlySelected);
                FileUtilities.getInstance().editFile(file);
            }
        }
        catch (RuntimeException ex) {
            LOGGER.severe("creating XML file failed", (Throwable)ex);
            Fx.error((String)RdcFxRdcBundle.getString("COULD NOT CREATE XML FILE"), (Throwable)ex);
        }
    }

    public void savePreferences(boolean system) {
        try {
            this.table.savePreferences(this.preferencesSuffix, system);
        }
        catch (RuntimeException ex) {
            LOGGER.severe("saving table preferences failed", (Throwable)ex);
            Fx.error((String)RdcFxRdcBundle.getString("SAVING PREFERENCES FAILED"), (Throwable)ex);
        }
    }

    public void savePreferences() {
        this.savePreferences(PersistedPreferencesFactory.getInstance().isSystemOnly());
    }

    public void loadPreferences(boolean system) {
        try {
            this.table.loadPreferences(this.preferencesSuffix, system);
        }
        catch (RuntimeException ex) {
            LOGGER.severe("loading table preferences failed", (Throwable)ex);
            Fx.error((String)RdcFxRdcBundle.getString("LOADING PREFERENCES FAILED"), (Throwable)ex);
        }
    }

    public void loadPreferences() {
        this.loadPreferences(PersistedPreferencesFactory.getInstance().isSystemOnly());
    }
}

